﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   PCM ドライバライブラリの API 宣言。
 */

#pragma once

#include <nn/nn_Common.h>

namespace nn {
namespace pcm {
namespace driver {

//! @name サスペンド・レジューム
//! @{

/**
 * @brief   全計測ポイントをサスペンドします。
 *
 * @pre
 *  ライブラリは初期化済の状態である必要があります。
 *
 * @post
 *  全計測ポイントがサスペンド状態になります。
 *
 * @details
 *  全計測ポイントをサスペンドします。@n
 *  サスペンド後も計測ポイントのオープン状態は維持されますが、ハードウェアは省電力状態に移行し、機能が利用できない状態になります。@n
 *  また、サスペンド状態中は新たな計測ポイントのオープンやオープン済計測ポイントのクローズはできません。@n
 *  すでにサスペンド状態で本関数を呼び出した場合、何もしません。
 */
void SuspendAllMeasuringPoints() NN_NOEXCEPT;

/**
 * @brief   全計測ポイントをレジュームします。
 *
 * @pre
 *  ライブラリは初期化済の状態である必要があります。
 *
 * @post
 *  全計測ポイントがサスペンド前の状態になります。
 *
 * @details
 *  全計測ポイントをレジュームし、サスペンド前の状態に戻します。@n
 *  サスペンド前の状態で本関数を呼び出した場合、何もしません。
 */
void ResumeAllMeasuringPoints() NN_NOEXCEPT;

//! @}
// ~サスペンド・レジューム

} // driver
} // pcm
} // nn
