﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Data types which are specific to the pcie driver
 */

#pragma once

namespace nn {
namespace pcie {
namespace driver {

/**
 * @brief Information about a PCI device function base address
 *        register (BAR)
 */
struct DriverBarProfile
{
    void*          pBase;
    uint64_t       base;
    uint64_t       size;
    RegionFlagMask flags;
};

/**
 * @brief Callback executed when newly arrived device function matches class driver
 *        specified criteria.
 */
typedef void (*RegistrationCallback)(uintptr_t classDriverContext);

/**
 * @brief Callback executed when an acquired device function goes through a power management
 *        state transition.
 */
typedef void (*PmStateCallback)(uintptr_t classDriverContext, uintptr_t functionContext, PmState pmState);

/**
 * @brief Prototype of software interrupt request (IRQ) callback
 *        function to be implemented by class driver.
 */
typedef void (*IrqCallback)(uintptr_t classDriverContext, int32_t zeroBasedIrqNumber);

/**
 * @brief Callback executed when logged state is updated
 */
typedef void (*LoggedStateCallback)(uintptr_t context, bool isDueToError);


} // driver
} // pcie
} // nn

