﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/dd.h>

#include <nn/pcie/pcie_Standard.h>
#include <nn/pcie/pcie_Id.h>
#include <nn/pcie/pcie_Types.h>
#include <nn/pcie/pcie_LoggedState.h>

namespace nn {
namespace pcie {
namespace driver {

Result Initialize();
Result Finalize();
Result GetLoggedState(LoggedState* pOutput, bool isCleared);
void   SetLoggedStateCallback(LoggedStateCallback callback, uintptr_t context);
Result QueryFunctions(FunctionState* pOutput, size_t queryBufferSize, int32_t* pNumReturned);
Result RegisterClassDriver(ClassDriverHandle *pReturnedHandle, const ClassDriverConfig *pCfg,
                           RegistrationCallback registrationCallback, PmStateCallback pmStateCallback);
Result UnregisterClassDriver(ClassDriverHandle classDriverHandle);
Result QueryFunctions(ClassDriverHandle classDriverHandle, FunctionState* pOutput,
                      size_t queryBufferSize, int32_t* pNumReturned);
Result AcquireFunction(ClassDriverHandle classDriverHandle, FunctionHandle functionHandle, uintptr_t functionContext);
Result ReleaseFunction(ClassDriverHandle classDriverHandle, FunctionHandle functionHandle);
Result ResetFunction(ClassDriverHandle classDriverHandle, FunctionHandle functionHandle, FunctionResetOptionMask resetOptionMask);
Result GetFunctionState(ClassDriverHandle classDriverHandle, FunctionHandle functionHandle, FunctionState* pOutput);
Result GetBarProfile(ClassDriverHandle classDriverHandle, FunctionHandle functionHandle,
                     uint8_t bar, DriverBarProfile *pReturnedProfile);
Result ReadConfig8(ClassDriverHandle classDriverHandle, FunctionHandle functionHandle, size_t offset, uint8_t *pOut);
Result ReadConfig16(ClassDriverHandle classDriverHandle, FunctionHandle functionHandle, size_t offset, uint16_t *pOut);
Result ReadConfig32(ClassDriverHandle classDriverHandle, FunctionHandle functionHandle, size_t offset, uint32_t *pOut);
Result WriteConfig8(ClassDriverHandle classDriverHandle, FunctionHandle functionHandle, size_t offset, uint8_t data);
Result WriteConfig16(ClassDriverHandle classDriverHandle, FunctionHandle functionHandle, size_t offset, uint16_t data);
Result WriteConfig32(ClassDriverHandle classDriverHandle, FunctionHandle functionHandle, size_t offset, uint32_t data);
Result ReadBarRegion8(ClassDriverHandle classDriverHandle, FunctionHandle functionHandle,
                      uint8_t bar, size_t offset, uint8_t *pRead8);
Result ReadBarRegion16(ClassDriverHandle classDriverHandle, FunctionHandle functionHandle,
                       uint8_t bar, size_t offset, uint16_t *pRead16);
Result ReadBarRegion32(ClassDriverHandle classDriverHandle, FunctionHandle functionHandle,
                       uint8_t bar, size_t offset, uint32_t *pRead32);
Result ReadBarRegion64(ClassDriverHandle classDriverHandle, FunctionHandle functionHandle,
                       uint8_t bar, size_t offset, uint64_t *pRead64);
Result ReadBarRegion(ClassDriverHandle classDriverHandle, FunctionHandle functionHandle, uint8_t bar, size_t offset,
                     BusAccessWidth accessWidth, size_t readSize, void *pReadData);
Result WriteBarRegion8(ClassDriverHandle classDriverHandle, FunctionHandle functionHandle,
                       uint8_t bar, size_t offset, uint8_t data8);
Result WriteBarRegion16(ClassDriverHandle classDriverHandle, FunctionHandle functionHandle,
                        uint8_t bar, size_t offset, uint16_t data16);
Result WriteBarRegion32(ClassDriverHandle classDriverHandle, FunctionHandle functionHandle,
                        uint8_t bar, size_t offset, uint32_t data32);
Result WriteBarRegion64(ClassDriverHandle classDriverHandle, FunctionHandle functionHandle,
                        uint8_t bar, size_t offset, uint64_t data64);
Result WriteBarRegion(ClassDriverHandle classDriverHandle, FunctionHandle functionHandle, uint8_t bar, size_t offset,
                      BusAccessWidth accessWidth, size_t writeSize, const void *pWriteData);
Result FindCapability(ClassDriverHandle classDriverHandle, FunctionHandle functionHandle, CapabilityId capabilityId, size_t *pReturnedOffset);
Result FindExtendedCapability(ClassDriverHandle classDriverHandle, FunctionHandle functionHandle, ExtendedCapabilityId extendedCapabilityId,
                              size_t *pReturnedOffset);
Result MapDma(ClassDriverHandle classDriverHandle, FunctionHandle functionHandle, DmaDirection direction,
              nn::dd::ProcessHandle processHandle, void *base, size_t size, BusAddress *pReturnedBusAddressBase);
Result UnmapDma(ClassDriverHandle classDriverHandle, FunctionHandle functionHandle, nn::dd::ProcessHandle processHandle, void *base);
Result UnmapDma(ClassDriverHandle classDriverHandle, FunctionHandle functionHandle, BusAddress busAddr);
Result GetDmaBusAddress(ClassDriverHandle classDriverHandle, FunctionHandle functionHandle, nn::dd::ProcessHandle processHandle, void *base,
                        size_t size, BusAddress *pReturnedBusAddressBase);
Result GetDmaBusAddressRange(ClassDriverHandle classDriverHandle, FunctionHandle functionHandle, BusAddress *pOutBase, BusAddress *pOutSize);
Result SetDmaEnable(ClassDriverHandle classDriverHandle, FunctionHandle functionHandle, bool isBusMasterEnabled);
Result GetMaxIrqCount(int32_t* pOutMaxIrqCount, ClassDriverHandle classDriverHandle, FunctionHandle functionHandle);
Result AcquireIrq(ClassDriverHandle classDriverHandle, FunctionHandle functionHandle, IrqCallback callback,
          uintptr_t irqContext, IrqType irqType, int32_t numberOfVectors);
Result ReleaseIrq(ClassDriverHandle classDriverHandle, FunctionHandle functionHandle);
Result SetIrqEnable(ClassDriverHandle classDriverHandle, FunctionHandle functionHandle, int32_t zeroBasedIrqNumber, bool irqEnabled);
Result SetAspmEnable(ClassDriverHandle classDriverHandle, FunctionHandle functionHandle, bool isEnabled);
Result SetResetUponResumeEnable(ClassDriverHandle classDriverHandle, FunctionHandle functionHandle, bool isEnabled);

} // driver
} // pcie
} // nn
