﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_TimeSpan.h>
#include <nn/omm/srv/omm_CradleObserver.h>
#include <nn/omm/srv/omm_DisplayManager.h>

namespace nn { namespace omm { namespace srv {
    class AwakeModeManager
    {
    public:
        void Initialize(DisplayManager* displayManager, CradleObserver* cradleObserver) NN_NOEXCEPT;

        void EnterSleepAndWait(os::SystemEvent* pSleepCancelEvent) NN_NOEXCEPT;

    private:
        void Sign(int x, int y, int width, int height, const void* buffer, size_t size, TimeSpan span, os::SystemEvent* pSleepCancelEvent) NN_NOEXCEPT;

        void ShowChargingBatteryImage(os::SystemEvent* pSleepCancelEvent) NN_NOEXCEPT;
        void FillInBlack(Bit32 *pBuffer, int bufferWidth, int bufferHeight, int width, int height, int offsetX, int offsetY) NN_NOEXCEPT;

        DisplayManager* m_DisplayManager;
        CradleObserver* m_CradleObserver;
        TimeSpan m_ChargingSignageSpan;
        TimeSpan m_LowBatterySignageSpan;
        TimeSpan m_SignageFadeInSpan;
        TimeSpan m_SignageFadeOutSpan;
        TimeSpan m_WaitLayerVisibleSpan;
    };
}}}
