﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fs/fs_SaveDataTransferForCloudBackUp.h>
#include <nn/nn_Common.h>
#include <nn/nn_ApplicationId.h>
#include <nn/os/os_SdkMutex.h>
#include <nn/util/util_Optional.h>

namespace nn { namespace olsc { namespace srv { namespace util {

class AutonomyUploadWaitingList
{
public:
    nn::util::optional<ApplicationId> PopFront() NN_NOEXCEPT;
    nn::util::optional<ApplicationId> GetFront() const NN_NOEXCEPT;
    int GetCount() const NN_NOEXCEPT;

    void Update(const ApplicationId ids[], int count) NN_NOEXCEPT;
    void Remove(ApplicationId appId) NN_NOEXCEPT;

    static const int MaxApplicationCount = 128;
private:
    mutable os::SdkRecursiveMutex m_Lock;

    class ApplicationIdList
    {
    public:
        int GetCount() const NN_NOEXCEPT;
        nn::util::optional<ApplicationId> PopFront() NN_NOEXCEPT;
        nn::util::optional<ApplicationId> GetFront() const NN_NOEXCEPT;
        void PushBack(ApplicationId appId) NN_NOEXCEPT;
        nn::util::optional<ApplicationId> Remove(ApplicationId appId) NN_NOEXCEPT;
    private:
        std::array<ApplicationId, MaxApplicationCount> m_Applications{};
        int m_Count = 0;

        nn::util::optional<ApplicationId> RemoveAt(int index) NN_NOEXCEPT;
        nn::util::optional<int> Find(ApplicationId appId) const NN_NOEXCEPT;
    };

    ApplicationIdList m_WaitingApplications;
};

}}}} // namespace nn::olsc::srv::util
