﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_ApplicationId.h>
#include <nn/olsc/sfdl/olsc_IOlscService.sfdl.h>
#include <nn/sf/sf_Types.h>

#include <nn/olsc/detail/olsc_Log.h>

namespace nn { namespace olsc { namespace srv {

class ForbiddenSaveDataIndicationImpl
{
    ApplicationId m_AppId;

    void UpdateImpl(const ApplicationId appIds[], int count) NN_NOEXCEPT
    {
        NN_UNUSED(appIds);
        NN_UNUSED(count);
        // TODO 実装
    }

public:
    explicit ForbiddenSaveDataIndicationImpl(ApplicationId appId) NN_NOEXCEPT
        : m_AppId(appId)
    {
        UpdateImpl(&m_AppId, 1);
        NN_DETAIL_OLSC_TRACE("Create ForbiddenSaveDataIndication for %016llx\n", m_AppId.value);
    }
    ~ForbiddenSaveDataIndicationImpl() NN_NOEXCEPT
    {
        NN_DETAIL_OLSC_TRACE("Destroy ForbiddenSaveDataIndication for %016llx\n", m_AppId.value);
    }

    Result Update(sf::InArray<ApplicationId> appIds) NN_NOEXCEPT
    {
        NN_DETAIL_OLSC_TRACE("Update ForbiddenSaveDataIndication\n");
        for (int i = 0; i < static_cast<int>(appIds.GetLength()); ++i)
        {
            NN_DETAIL_OLSC_TRACE("  - %016llx\n", appIds[i]);
        }
        UpdateImpl(appIds.GetData(), static_cast<int>(appIds.GetLength()));
        NN_RESULT_SUCCESS;
    }
};

}}} // ~namespace nn::olsc::srv
