﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/sf/sf_IServiceObject.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Out.h>
#include <nn/util/util_Execution.h>
#include <nn/util/util_Optional.h>

namespace nn { namespace olsc { namespace srv {

class AsyncResultImplBase
{
public:
    void Finalize() NN_NOEXCEPT;
    Result GetResult() NN_NOEXCEPT;
    Result Cancel() NN_NOEXCEPT;
    Result IsAvailable(sf::Out<bool> outValue) NN_NOEXCEPT;
    Result GetSystemEvent(sf::Out<sf::NativeHandle> outValue) NN_NOEXCEPT;

protected:
    Result Initialize(nn::util::Executable& executable, nn::util::AbstractExecutor& executor) NN_NOEXCEPT;

private:
    nn::util::optional<nn::util::AsyncExecution> m_AsyncExecution;
    nn::util::Executable* m_Executable{ nullptr };
};

template <typename Executable>
class AsyncResultImpl
    : public sf::IServiceObject
    , public AsyncResultImplBase
{
private:
    Executable m_Executable;

public:
    template <typename... Args>
    explicit AsyncResultImpl(Args&&... args) NN_NOEXCEPT
        : m_Executable{ std::forward<Args>(args)... }
    {
    }
    ~AsyncResultImpl() NN_NOEXCEPT
    {
        // m_Executable を AsyncResultImplBase が参照しているため、先に Finalize して開放すること
        AsyncResultImplBase::Finalize();
    }
    Result Initialize(nn::util::AbstractExecutor& executor) NN_NOEXCEPT
    {
        return AsyncResultImplBase::Initialize(m_Executable, executor);
    }
};

}}} // namespace nn::olsc::srv
