﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/http/json/http_JsonPath.h>

namespace nn { namespace olsc { namespace srv { namespace adaptor {

template<int Depth, int Length>
class AdaptorBase
{
public:
    typedef nn::http::json::JsonPath<Depth, Length, false> JsonPathType;

    AdaptorBase() NN_NOEXCEPT
    {}

    void Update(const JsonPathType& jsonPath, std::nullptr_t n) NN_NOEXCEPT
    {
        if (m_CanContinue)
        {
            m_CanContinue = UpdateImpl(jsonPath, n);
        }
    }
    void Update(const JsonPathType& jsonPath, bool value) NN_NOEXCEPT
    {
        if (m_CanContinue)
        {
            m_CanContinue = UpdateImpl(jsonPath, value);
        }
    }
    void Update(const JsonPathType& jsonPath, int64_t value) NN_NOEXCEPT
    {
        if (m_CanContinue)
        {
            m_CanContinue = UpdateImpl(jsonPath, value);
        }
    }
    void Update(const JsonPathType& jsonPath, uint64_t value) NN_NOEXCEPT
    {
        if (m_CanContinue)
        {
            m_CanContinue = UpdateImpl(jsonPath, value);
        }
    }
    void Update(const JsonPathType& jsonPath, double value) NN_NOEXCEPT
    {
        if (m_CanContinue)
        {
            m_CanContinue = UpdateImpl(jsonPath, value);
        }
    }
    void Update(const JsonPathType& jsonPath, const char* value, int valueLength) NN_NOEXCEPT
    {
        if (m_CanContinue)
        {
            m_CanContinue = UpdateImpl(jsonPath, value, valueLength);
        }
    }
    void NotifyObjectBegin(const JsonPathType& jsonPath) NN_NOEXCEPT
    {
        if (m_CanContinue)
        {
            m_CanContinue = NotifyObjectBeginImpl(jsonPath);
        }
    }
    void NotifyObjectEnd(const JsonPathType& jsonPath) NN_NOEXCEPT
    {
        if (m_CanContinue)
        {
            m_CanContinue = NotifyObjectEndImpl(jsonPath);
        }
    }
    virtual bool UpdateImpl(const JsonPathType&, std::nullptr_t) NN_NOEXCEPT
    {
        return true;
    }
    virtual bool UpdateImpl(const JsonPathType&, bool) NN_NOEXCEPT
    {
        return true;
    }
    virtual bool UpdateImpl(const JsonPathType&, int64_t) NN_NOEXCEPT
    {
        return true;
    }
    virtual bool UpdateImpl(const JsonPathType&, uint64_t) NN_NOEXCEPT
    {
        return true;
    }
    virtual bool UpdateImpl(const JsonPathType&, double) NN_NOEXCEPT
    {
        return true;
    }
    virtual bool UpdateImpl(const JsonPathType&, const char*, int) NN_NOEXCEPT
    {
        return true;
    }
    virtual bool NotifyObjectBeginImpl(const JsonPathType&) NN_NOEXCEPT
    {
        return true;
    }
    virtual bool NotifyObjectEndImpl(const JsonPathType&) NN_NOEXCEPT
    {
        return true;
    }

    Result GetResult() const NN_NOEXCEPT
    {
        return m_Result;
    }

protected:

    void SetResult(const Result& result) NN_NOEXCEPT
    {
        m_Result = result;
    }

private:
    Result m_Result = ResultSuccess();
    bool m_CanContinue = true;
};

}}}} // namespace nn::olsc::srv::adaptor
