﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_SystemEvent.h>

/**
 *  @file
 *  @brief      olsc ライブラリの返す SystemEvent を管理するオブジェクトです。
 */

namespace nn { namespace olsc {
    namespace srv {
        class INativeHandleHolder;
    }

    /**
    *
    *   @brief  olsc ライブラリの返す SystemEvent を管理するオブジェクトです。
    *
    */
    class SystemEventHolder
    {
        NN_DISALLOW_COPY(SystemEventHolder);

    public:
        SystemEventHolder() NN_NOEXCEPT;
        NN_IMPLICIT SystemEventHolder(srv::INativeHandleHolder* stopper) NN_NOEXCEPT;
        ~SystemEventHolder() NN_NOEXCEPT;

        SystemEventHolder& operator=(SystemEventHolder&& rhs) NN_NOEXCEPT;
        SystemEventHolder(SystemEventHolder&& rhs) NN_NOEXCEPT;

        void GetSystemEvent(os::SystemEvent* out) NN_NOEXCEPT;

    private:
        friend void swap(SystemEventHolder& lhs, SystemEventHolder& rhs) NN_NOEXCEPT;
        srv::INativeHandleHolder* m_NativeHandleHolder;
    };

    void swap(SystemEventHolder& lhs, SystemEventHolder& rhs) NN_NOEXCEPT;

}} // namespace nn::olsc
