﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
    @file
    @brief サブプログラムジャンプ API 宣言
*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_ApplicationId.h>

namespace nn { namespace oe {

//! @name サブプログラムへのジャンプ API (開発専用)
//! @{

Result RestartProgram(const void* data, size_t dataSize) NN_NOEXCEPT;
Result ExecuteProgram(uint8_t programIndex, const void* data, size_t dataSize) NN_NOEXCEPT;
int GetPreviousProgramIndex() NN_NOEXCEPT;

/**
    @brief (開発専用) サブプログラムへ処理を移行します。

    @param[in] applicationId ジャンプ先のアプリケーションの ID を指定します。
    @param[in] data 渡すデータを格納したバッファの先頭アドレスを指定します。
    @param[in] dataSize 渡すデータのサイズを指定します。

    @pre 開発時の実行である
    @pre applicationId が有効なアプリケーションの ID で、実行可能である
    @pre dataSize <= 4096
    @pre [data, data + dataSize) の領域が読み込み可能である

    @details
     本関数は Nin1 アプリケーションの開発・評価目的用の関数であり、
     正式な Nin1 用関数が作成されたら削除される予定です。
     製品では使用できません。

     本関数を呼び出すと、現在のプログラムを終了し、applicationId で指定されたアプリケーションプログラムに置き換えます。
*/
Result JumpToSubProgramForDevelopment(nn::ApplicationId applicationId, const void* data, size_t dataSize) NN_NOEXCEPT;

//! @}

}}
