﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   キャプチャボタン短押しに関する API の宣言
 *
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/oe/oe_NotificationMessage.h>

namespace nn { namespace oe {

/**
 * @brief   キャプチャボタン短押し時のメッセージ通知です。
 *
 * @details
 *  キャプチャボタンが短押しされたことを示すメッセージ通知です。
 *
 *  このメッセージは、以下の API 呼出しに挟まれた、
 *  キャプチャボタン短押しハンドリング区間中にのみ通知されます。
 *
 *  - nn::oe::BeginHandlingCaptureButtonShortPressed()
 *  - nn::oe::EndHandlingCaptureButtonShortPressed()
 *
 */
const Message MessageCaptureButtonPressedShortly = 90;


//--------------------------------------------------------------------------

//! @name キャプチャボタン短押し制御機能
//! @{

/**
    @brief キャプチャボタン短押しのハンドリングを開始します。

    @details
     キャプチャボタン短押しのハンドリングを開始するときに発行して下さい。

     本 API でハンドリングを開始すると、実際にキャプチャボタンが短押し
     された時に、アプリに対して nn::oe::MessageCaptureButtonPressedShortly の
     メッセージが通知されるようになります。

     キャプチャボタン短押しのハンドリングを終了には、
     nn::oe::EndHandlingCaptureButtonShortPressed() を発行して下さい。

*/
void BeginHandlingCaptureButtonShortPressed() NN_NOEXCEPT;

/**
    @brief キャプチャボタン短押しのハンドリングを終了します。

    @details
     キャプチャボタン短押しのハンドリングを終了するときに発行して下さい。
     詳細は nn::oe::BeginHandlingCaptureButtonShortPressed() を参照して下さい。

*/
void EndHandlingCaptureButtonShortPressed() NN_NOEXCEPT;

//! @}

//-----------------------------------------------------------------------------

}} // namespace nn::oe


