﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ntc/detail/service/ntc_Common.h>
#include <nn/ntc/detail/service/core/ntc_SerializeTaskThread.h>
#include <nn/os.h>
#include <nn/util/util_Optional.h>

namespace nn { namespace ntc { namespace detail { namespace service {

class DefaultEnsureNetworkClockAvailabilityTaskExecutor : public core::TaskExecutor
{
public:
    virtual nn::Result Execute() NN_NOEXCEPT NN_OVERRIDE;
};

class ForcibleDownloadEnsureNetworkClockAvailabilityTaskExecutor : public core::TaskExecutor
{
public:
    virtual nn::Result Execute() NN_NOEXCEPT NN_OVERRIDE;
};

class GetServerTimeTaskExecutor : public core::TaskExecutor
{
public:
    GetServerTimeTaskExecutor() NN_NOEXCEPT;
    virtual nn::Result Execute() NN_NOEXCEPT NN_OVERRIDE;
    nn::Result GetServerTime(nn::time::PosixTime* pOut) NN_NOEXCEPT;

private:
    nn::os::Mutex m_ServerTimeLock;
    nn::util::optional<nn::time::PosixTime> m_ServerTime;
};

}}}} // nn::ntc::detail::service
