﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief 設定の保存モード
 */

#pragma once

#include <nn/nsd/nsd_Common.h>

namespace nn { namespace nsd {

    /**
     * @brief   サービスディスカバリの設定をデバイスへインポートする際のモードです。
     * @see     nn::nsd::ImportSettings()
     */
    enum ImportMode
    {
        ImportMode_All, //!< すべての設定群の変更を許可します。
        ImportMode_ApplicationSettings, //!< アプリケーション向け設定の変更のみを許可します。
    };

}} // nn::nsd
