﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief 基幹サービス向け設定の型定義(非公開)
 */

#pragma once

#include <nn/nsd/nsd_Common.h>
#include <nn/nsd/nsd_BackboneSettingsTypes.h>

namespace nn { namespace nsd {

    /**
     * @brief   NAS サービス利用のための設定群を表す構造体
     */
    struct NasServiceSettings
    {
        static const size_t NasServiceEntryCountMax = 8; //!< 設定可能な NAS サービスの最大数

        /**
         * @brief   NAS を利用するサービスの名称・設定を表す型
         */
        struct Entry
        {
            NasServiceName nasServiceName; //!< サービス名
            NasServiceSetting nasServiceSetting; //!< サービス利用のための設定
        };

        Fqdn nasRequestServiceFqdn; //!< NAS の認証・トークンリクエストを扱うサーバーの FQDN
        Fqdn nasApiServiceFqdn; //!< NAS の API を扱うサーバーの FQDN
        Entry entries[NasServiceEntryCountMax]; //!< 各種サービスの設定群
    };

}} // nn::nsd
