﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief NAS サービス向けの nn::nsd API(非公開)
 */

#pragma once

#include <nn/nsd/nsd_Common.h>
#include <nn/nsd/nsd_BackboneSettingsTypes.h>

namespace nn { namespace nsd {

    /**
     * @brief   NAS の認証・トークン取得リクエスト用の FQDN を取得します。エラーハンドリングが必須な API です。
     * @param[out]  pOut    FQDN
     *
     * @retresult
     *      @handleresult{ResultInvalidSettingVersion}
     *      @handleresult{ResultInvalidSettingData}
     *      @handleresult{ResultNotFound, 設定が存在しません}
     * @endretresult
     *
     * @pre
     *  - pOut != nullptr
     *
     * @details
     *  本 API の失敗は実運用においても起こりえるので、
     *  必ずエラーハンドリングを行ってください。
     *
     *  エラーハンドリングやシーケンス分岐を行いたくない場合は @ref GetNasRequestFqdnEx 関数を利用してください。
     *
     * @see     GetNasRequestFqdnEx()
     */
    Result GetNasRequestFqdn(Fqdn* pOut) NN_NOEXCEPT;

    /**
     * @brief   NAS の認証・トークン取得リクエスト用の FQDN を取得します。
     * @param[out]  pOut    FQDN
     * @pre
     *  - pOut != nullptr
     *
     * @details
     *  インポート済設定の互換性がない場合には、無効な FQDN を出力します
     *  (文字列としては正しい仕様の FQDN を出力します)。@n
     *  その場合 socket での名前解決が必ず失敗します。
     *
     * @see     GetNasRequestFqdn()
     */
    void GetNasRequestFqdnEx(Fqdn* pOut) NN_NOEXCEPT;

    /**
     * @brief   NAS の API 用の FQDN を取得します。エラーハンドリングが必須な API です。
     * @param[out]  pOut    FQDN
     *
     * @retresult
     *      @handleresult{ResultInvalidSettingVersion}
     *      @handleresult{ResultInvalidSettingData}
     *      @handleresult{ResultNotFound, 設定が存在しません}
     * @endretresult
     *
     * @pre
     *  - pOut != nullptr
     *
     * @details
     *  本 API の失敗は実運用においても起こりえるので、
     *  必ずエラーハンドリングを行ってください。
     *
     *  エラーハンドリングやシーケンス分岐を行いたくない場合は @ref GetNasApiFqdnEx 関数を利用してください。
     *
     * @see     GetNasApiFqdnEx()
     */
    Result GetNasApiFqdn(Fqdn* pOut) NN_NOEXCEPT;

    /**
     * @brief   NAS の認証・トークン取得リクエスト用の FQDN を取得します。
     * @param[out]  pOut    FQDN
     * @pre
     *  - pOut != nullptr
     *
     * @details
     *  インポート済設定の互換性がない場合には、無効な FQDN を出力します
     *  (文字列としては正しい仕様の FQDN を出力します)。@n
     *  その場合 socket での名前解決が必ず失敗します。
     *
     * @see     GetNasApiFqdn()
     */
    void GetNasApiFqdnEx(Fqdn* pOut) NN_NOEXCEPT;
}} // nn::nsd
