﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief NAS サービス向けの nn::nsd API
 */

#pragma once

#include <nn/nsd/nsd_Common.h>
#include <nn/nsd/nsd_BackboneSettingsTypes.h>

namespace nn { namespace nsd {

//! @name NAS サービス利用のための API
//! @{

    /**
     * @brief   NAS サービスを利用するための設定を取得します。エラーハンドリングが必須な API です。
     * @param[out]  pOutNasServiceSetting   設定を入れるバッファ
     * @param[in]   nasServiceName          設定を取得したいサービスの名前
     *
     * @retresult
     *      @handleresult{ResultInvalidSettingVersion}
     *      @handleresult{ResultInvalidSettingData}
     *      @handleresult{ResultNotFound, 指定の NasServiceName に該当する設定が存在しません}
     * @endretresult
     *
     * @pre
     *  - pOutNasServiceSetting != nullptr
     *
     * @details
     *  指定の NasServiceName のサービス利用に必要な設定を pOutNasServiceSetting へ格納します。
     *
     *  本 API の失敗は、実運用においても起こりえるので、
     *  必ずエラーハンドリングを行ってください。
     *
     *  エラーハンドリングやシーケンス分岐を行いたくない場合は @ref GetNasServiceSettingEx 関数を利用してください。
     *
     *  利用可能な NasServiceName は以下です。
     *  - nn::nsd::NasServiceNameOfNxAccount
     *  - nn::nsd::NasServiceNameOfNxShop
     *  - nn::nsd::NasServiceNameOfNxFriends
     *  - nn::nsd::NasServiceNameOfNxELicense
     *
     * @see     GetNasServiceSettingEx
     */
    Result GetNasServiceSetting(
        NasServiceSetting* pOutNasServiceSetting,
        const NasServiceName& nasServiceName) NN_NOEXCEPT;

    /**
     * @brief   NAS サービスを利用するための設定を取得します。
     * @param[out]  pOutNasServiceSetting   設定を入れるバッファ
     * @param[in]   nasServiceName          設定を取得したいサービスの名前
     * @pre
     *  - pOutNasServiceSetting != nullptr
     *  - 利用可能な NasServiceName を指定している
     *
     * @details
     *  指定の NasServiceName のサービス利用に必要な設定を pOutNasServiceSetting へ格納します。
     *
     *  インポート済設定の互換性がない場合には、無効な設定を出力します。@n
     *  その場合、サーバーに対するリクエストは必ず失敗します。
     *
     *  利用可能な NasServiceName は以下です。
     *  - nn::nsd::NasServiceNameOfNxAccount
     *  - nn::nsd::NasServiceNameOfNxShop
     *  - nn::nsd::NasServiceNameOfNxFriends
     *  - nn::nsd::NasServiceNameOfNxELicense
     *
     * @see     GetNasServiceSetting()
     */
    void GetNasServiceSettingEx(
        NasServiceSetting* pOutNasServiceSetting,
        const NasServiceName& nasServiceName) NN_NOEXCEPT;

//! @}

}} // nn::nsd
