﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/nn_Result.h>
#include <nn/nsd/nsd_BackboneSettingsTypes.h>
#include <nn/nsd/nsd_Types.h>
#include <nn/nsd/nsd_TypesPrivate.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace nsd { namespace detail { // NOLINT(whitespace/braces)

class IManager;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IManager, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IManager)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSettingName, (::nn::sf::Out<::nn::nsd::SettingName> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetEnvironmentIdentifier, (::nn::sf::Out<::nn::nsd::EnvironmentIdentifier> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDeviceId, (::nn::sf::Out<::nn::nsd::DeviceId> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteSettings, (::std::int32_t deleteMode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ImportSettings, (const ::nn::sf::InBuffer& pBuffer, const ::nn::sf::OutBuffer& pWorkBuffer, ::std::int32_t importMode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetChangeEnvironmentIdentifierDisabled, (bool isDisabled))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Resolve, (::nn::sf::Out<::nn::nsd::Fqdn> pOut, const ::nn::nsd::Fqdn& fqdn))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ResolveEx, (::nn::sf::Out<::nn::nsd::InnerResult> pInnerResult, ::nn::sf::Out<::nn::nsd::Fqdn> pOut, const ::nn::nsd::Fqdn& fqdn))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetNasServiceSetting, (::nn::sf::Out<::nn::nsd::NasServiceSetting> pOutNasServiceSetting, const ::nn::nsd::NasServiceName& nasServiceName))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetNasServiceSettingEx, (::nn::sf::Out<::nn::nsd::InnerResult> pInnerResult, ::nn::sf::Out<::nn::nsd::NasServiceSetting> pOutNasServiceSetting, const ::nn::nsd::NasServiceName& nasServiceName))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetNasRequestFqdn, (::nn::sf::Out<::nn::nsd::Fqdn> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetNasRequestFqdnEx, (::nn::sf::Out<::nn::nsd::InnerResult> pInnerResult, ::nn::sf::Out<::nn::nsd::Fqdn> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetNasApiFqdn, (::nn::sf::Out<::nn::nsd::Fqdn> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetNasApiFqdnEx, (::nn::sf::Out<::nn::nsd::InnerResult> pInnerResult, ::nn::sf::Out<::nn::nsd::Fqdn> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetCurrentSetting, (::nn::sf::Out<::nn::nsd::SaveData> pSaveData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ReadSaveDataFromFsForTest, (::nn::sf::Out<::nn::nsd::SaveData> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(WriteSaveDataToFsForTest, (const ::nn::nsd::SaveData& saveData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DeleteSaveDataOfFsForTest)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsChangeEnvironmentIdentifierDisabled, (::nn::sf::Out<bool> outValue))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IManager)

        ::nn::Result GetSettingName(::nn::sf::Out<::nn::nsd::SettingName> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSettingName, (pOut));
        }

        ::nn::Result GetEnvironmentIdentifier(::nn::sf::Out<::nn::nsd::EnvironmentIdentifier> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetEnvironmentIdentifier, (pOut));
        }

        ::nn::Result GetDeviceId(::nn::sf::Out<::nn::nsd::DeviceId> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDeviceId, (pOut));
        }

        ::nn::Result DeleteSettings(::std::int32_t deleteMode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteSettings, (deleteMode));
        }

        ::nn::Result ImportSettings(const ::nn::sf::InBuffer& pBuffer, const ::nn::sf::OutBuffer& pWorkBuffer, ::std::int32_t importMode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ImportSettings, (pBuffer, pWorkBuffer, importMode));
        }

        ::nn::Result SetChangeEnvironmentIdentifierDisabled(bool isDisabled) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetChangeEnvironmentIdentifierDisabled, (isDisabled));
        }

        ::nn::Result Resolve(::nn::sf::Out<::nn::nsd::Fqdn> pOut, const ::nn::nsd::Fqdn& fqdn) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Resolve, (pOut, fqdn));
        }

        ::nn::Result ResolveEx(::nn::sf::Out<::nn::nsd::InnerResult> pInnerResult, ::nn::sf::Out<::nn::nsd::Fqdn> pOut, const ::nn::nsd::Fqdn& fqdn) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ResolveEx, (pInnerResult, pOut, fqdn));
        }

        ::nn::Result GetNasServiceSetting(::nn::sf::Out<::nn::nsd::NasServiceSetting> pOutNasServiceSetting, const ::nn::nsd::NasServiceName& nasServiceName) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetNasServiceSetting, (pOutNasServiceSetting, nasServiceName));
        }

        ::nn::Result GetNasServiceSettingEx(::nn::sf::Out<::nn::nsd::InnerResult> pInnerResult, ::nn::sf::Out<::nn::nsd::NasServiceSetting> pOutNasServiceSetting, const ::nn::nsd::NasServiceName& nasServiceName) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetNasServiceSettingEx, (pInnerResult, pOutNasServiceSetting, nasServiceName));
        }

        ::nn::Result GetNasRequestFqdn(::nn::sf::Out<::nn::nsd::Fqdn> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetNasRequestFqdn, (pOut));
        }

        ::nn::Result GetNasRequestFqdnEx(::nn::sf::Out<::nn::nsd::InnerResult> pInnerResult, ::nn::sf::Out<::nn::nsd::Fqdn> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetNasRequestFqdnEx, (pInnerResult, pOut));
        }

        ::nn::Result GetNasApiFqdn(::nn::sf::Out<::nn::nsd::Fqdn> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetNasApiFqdn, (pOut));
        }

        ::nn::Result GetNasApiFqdnEx(::nn::sf::Out<::nn::nsd::InnerResult> pInnerResult, ::nn::sf::Out<::nn::nsd::Fqdn> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetNasApiFqdnEx, (pInnerResult, pOut));
        }

        ::nn::Result GetCurrentSetting(::nn::sf::Out<::nn::nsd::SaveData> pSaveData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetCurrentSetting, (pSaveData));
        }

        ::nn::Result ReadSaveDataFromFsForTest(::nn::sf::Out<::nn::nsd::SaveData> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ReadSaveDataFromFsForTest, (pOut));
        }

        ::nn::Result WriteSaveDataToFsForTest(const ::nn::nsd::SaveData& saveData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(WriteSaveDataToFsForTest, (saveData));
        }

        ::nn::Result DeleteSaveDataOfFsForTest() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DeleteSaveDataOfFsForTest);
        }

        ::nn::Result IsChangeEnvironmentIdentifierDisabled(::nn::sf::Out<bool> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsChangeEnvironmentIdentifierDisabled, (outValue));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IManager
    {
    public:
        nn::Result GetSettingName(nn::sf::Out<nn::nsd::SettingName> pOut) NN_NOEXCEPT;
        nn::Result GetEnvironmentIdentifier(nn::sf::Out<nn::nsd::EnvironmentIdentifier> pOut) NN_NOEXCEPT;
        nn::Result GetDeviceId(nn::sf::Out<nn::nsd::DeviceId> pOut) NN_NOEXCEPT;
        nn::Result DeleteSettings(std::int32_t deleteMode) NN_NOEXCEPT;
        nn::Result ImportSettings(const nn::sf::InBuffer& pBuffer, const nn::sf::OutBuffer& pWorkBuffer, std::int32_t importMode) NN_NOEXCEPT;
        nn::Result SetChangeEnvironmentIdentifierDisabled(bool isDisabled) NN_NOEXCEPT;
        nn::Result Resolve(nn::sf::Out<nn::nsd::Fqdn> pOut, const nn::nsd::Fqdn& fqdn) NN_NOEXCEPT;
        nn::Result ResolveEx(nn::sf::Out<nn::nsd::InnerResult> pInnerResult, nn::sf::Out<nn::nsd::Fqdn> pOut, const nn::nsd::Fqdn& fqdn) NN_NOEXCEPT;
        nn::Result GetNasServiceSetting(nn::sf::Out<nn::nsd::NasServiceSetting> pOutNasServiceSetting, const nn::nsd::NasServiceName& nasServiceName) NN_NOEXCEPT;
        nn::Result GetNasServiceSettingEx(nn::sf::Out<nn::nsd::InnerResult> pInnerResult, nn::sf::Out<nn::nsd::NasServiceSetting> pOutNasServiceSetting, const nn::nsd::NasServiceName& nasServiceName) NN_NOEXCEPT;
        nn::Result GetNasRequestFqdn(nn::sf::Out<nn::nsd::Fqdn> pOut) NN_NOEXCEPT;
        nn::Result GetNasRequestFqdnEx(nn::sf::Out<nn::nsd::InnerResult> pInnerResult, nn::sf::Out<nn::nsd::Fqdn> pOut) NN_NOEXCEPT;
        nn::Result GetNasApiFqdn(nn::sf::Out<nn::nsd::Fqdn> pOut) NN_NOEXCEPT;
        nn::Result GetNasApiFqdnEx(nn::sf::Out<nn::nsd::InnerResult> pInnerResult, nn::sf::Out<nn::nsd::Fqdn> pOut) NN_NOEXCEPT;
        nn::Result GetCurrentSetting(nn::sf::Out<nn::nsd::SaveData> pSaveData) NN_NOEXCEPT;
        nn::Result ReadSaveDataFromFsForTest(nn::sf::Out<nn::nsd::SaveData> pOut) NN_NOEXCEPT;
        nn::Result WriteSaveDataToFsForTest(const nn::nsd::SaveData& saveData) NN_NOEXCEPT;
        nn::Result DeleteSaveDataOfFsForTest() NN_NOEXCEPT;
        nn::Result IsChangeEnvironmentIdentifierDisabled(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetSettingName(nn::sf::Out<nn::nsd::SettingName> pOut) NN_NOEXCEPT;
    nn::Result GetEnvironmentIdentifier(nn::sf::Out<nn::nsd::EnvironmentIdentifier> pOut) NN_NOEXCEPT;
    nn::Result GetDeviceId(nn::sf::Out<nn::nsd::DeviceId> pOut) NN_NOEXCEPT;
    nn::Result DeleteSettings(std::int32_t deleteMode) NN_NOEXCEPT;
    nn::Result ImportSettings(const nn::sf::InBuffer& pBuffer, const nn::sf::OutBuffer& pWorkBuffer, std::int32_t importMode) NN_NOEXCEPT;
    nn::Result SetChangeEnvironmentIdentifierDisabled(bool isDisabled) NN_NOEXCEPT;
    nn::Result Resolve(nn::sf::Out<nn::nsd::Fqdn> pOut, const nn::nsd::Fqdn& fqdn) NN_NOEXCEPT;
    nn::Result ResolveEx(nn::sf::Out<nn::nsd::InnerResult> pInnerResult, nn::sf::Out<nn::nsd::Fqdn> pOut, const nn::nsd::Fqdn& fqdn) NN_NOEXCEPT;
    nn::Result GetNasServiceSetting(nn::sf::Out<nn::nsd::NasServiceSetting> pOutNasServiceSetting, const nn::nsd::NasServiceName& nasServiceName) NN_NOEXCEPT;
    nn::Result GetNasServiceSettingEx(nn::sf::Out<nn::nsd::InnerResult> pInnerResult, nn::sf::Out<nn::nsd::NasServiceSetting> pOutNasServiceSetting, const nn::nsd::NasServiceName& nasServiceName) NN_NOEXCEPT;
    nn::Result GetNasRequestFqdn(nn::sf::Out<nn::nsd::Fqdn> pOut) NN_NOEXCEPT;
    nn::Result GetNasRequestFqdnEx(nn::sf::Out<nn::nsd::InnerResult> pInnerResult, nn::sf::Out<nn::nsd::Fqdn> pOut) NN_NOEXCEPT;
    nn::Result GetNasApiFqdn(nn::sf::Out<nn::nsd::Fqdn> pOut) NN_NOEXCEPT;
    nn::Result GetNasApiFqdnEx(nn::sf::Out<nn::nsd::InnerResult> pInnerResult, nn::sf::Out<nn::nsd::Fqdn> pOut) NN_NOEXCEPT;
    nn::Result GetCurrentSetting(nn::sf::Out<nn::nsd::SaveData> pSaveData) NN_NOEXCEPT;
    nn::Result ReadSaveDataFromFsForTest(nn::sf::Out<nn::nsd::SaveData> pOut) NN_NOEXCEPT;
    nn::Result WriteSaveDataToFsForTest(const nn::nsd::SaveData& saveData) NN_NOEXCEPT;
    nn::Result DeleteSaveDataOfFsForTest() NN_NOEXCEPT;
    nn::Result IsChangeEnvironmentIdentifierDisabled(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::nsd::detail::IManager))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSettingName, (::nn::sf::Out<::nn::nsd::SettingName> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSettingName, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetEnvironmentIdentifier, (::nn::sf::Out<::nn::nsd::EnvironmentIdentifier> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetEnvironmentIdentifier, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDeviceId, (::nn::sf::Out<::nn::nsd::DeviceId> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDeviceId, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteSettings, (::std::int32_t deleteMode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteSettings, (deleteMode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ImportSettings, (const ::nn::sf::InBuffer& pBuffer, const ::nn::sf::OutBuffer& pWorkBuffer, ::std::int32_t importMode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ImportSettings, (pBuffer, pWorkBuffer, importMode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetChangeEnvironmentIdentifierDisabled, (bool isDisabled))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetChangeEnvironmentIdentifierDisabled, (isDisabled));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Resolve, (::nn::sf::Out<::nn::nsd::Fqdn> pOut, const ::nn::nsd::Fqdn& fqdn))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Resolve, (pOut, fqdn));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResolveEx, (::nn::sf::Out<::nn::nsd::InnerResult> pInnerResult, ::nn::sf::Out<::nn::nsd::Fqdn> pOut, const ::nn::nsd::Fqdn& fqdn))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ResolveEx, (pInnerResult, pOut, fqdn));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNasServiceSetting, (::nn::sf::Out<::nn::nsd::NasServiceSetting> pOutNasServiceSetting, const ::nn::nsd::NasServiceName& nasServiceName))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetNasServiceSetting, (pOutNasServiceSetting, nasServiceName));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNasServiceSettingEx, (::nn::sf::Out<::nn::nsd::InnerResult> pInnerResult, ::nn::sf::Out<::nn::nsd::NasServiceSetting> pOutNasServiceSetting, const ::nn::nsd::NasServiceName& nasServiceName))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetNasServiceSettingEx, (pInnerResult, pOutNasServiceSetting, nasServiceName));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNasRequestFqdn, (::nn::sf::Out<::nn::nsd::Fqdn> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetNasRequestFqdn, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNasRequestFqdnEx, (::nn::sf::Out<::nn::nsd::InnerResult> pInnerResult, ::nn::sf::Out<::nn::nsd::Fqdn> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetNasRequestFqdnEx, (pInnerResult, pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNasApiFqdn, (::nn::sf::Out<::nn::nsd::Fqdn> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetNasApiFqdn, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNasApiFqdnEx, (::nn::sf::Out<::nn::nsd::InnerResult> pInnerResult, ::nn::sf::Out<::nn::nsd::Fqdn> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetNasApiFqdnEx, (pInnerResult, pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCurrentSetting, (::nn::sf::Out<::nn::nsd::SaveData> pSaveData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetCurrentSetting, (pSaveData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadSaveDataFromFsForTest, (::nn::sf::Out<::nn::nsd::SaveData> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ReadSaveDataFromFsForTest, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WriteSaveDataToFsForTest, (const ::nn::nsd::SaveData& saveData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(WriteSaveDataToFsForTest, (saveData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeleteSaveDataOfFsForTest)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DeleteSaveDataOfFsForTest);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsChangeEnvironmentIdentifierDisabled, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsChangeEnvironmentIdentifierDisabled, (outValue));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::nsd::detail::IManager>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::nsd::detail::IManager))

    // nn::Result GetSettingName(nn::sf::Out<nn::nsd::SettingName> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSettingName)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pOut, 0, (::nn::sf::Out<::nn::nsd::SettingName>), 256, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSettingName)

    // nn::Result GetEnvironmentIdentifier(nn::sf::Out<nn::nsd::EnvironmentIdentifier> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetEnvironmentIdentifier)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pOut, 0, (::nn::sf::Out<::nn::nsd::EnvironmentIdentifier>), 8, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetEnvironmentIdentifier)

    // nn::Result GetDeviceId(nn::sf::Out<nn::nsd::DeviceId> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDeviceId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (::nn::nsd::DeviceId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDeviceId)

    // nn::Result DeleteSettings(std::int32_t deleteMode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteSettings)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deleteMode, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deleteMode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deleteMode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteSettings)

    // nn::Result ImportSettings(const nn::sf::InBuffer& pBuffer, const nn::sf::OutBuffer& pWorkBuffer, std::int32_t importMode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ImportSettings)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(14)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pBuffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pWorkBuffer, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (pBuffer, pWorkBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(importMode, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (importMode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pWorkBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(importMode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ImportSettings)

    // nn::Result SetChangeEnvironmentIdentifierDisabled(bool isDisabled) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetChangeEnvironmentIdentifierDisabled)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(15)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isDisabled, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (isDisabled))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isDisabled)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetChangeEnvironmentIdentifierDisabled)

    // nn::Result Resolve(nn::sf::Out<nn::nsd::Fqdn> pOut, const nn::nsd::Fqdn& fqdn) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Resolve)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pOut, 0, (::nn::sf::Out<::nn::nsd::Fqdn>), 256, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(fqdn, 1, (const ::nn::nsd::Fqdn&), 256, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (pOut, fqdn))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(fqdn)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Resolve)

    // nn::Result ResolveEx(nn::sf::Out<nn::nsd::InnerResult> pInnerResult, nn::sf::Out<nn::nsd::Fqdn> pOut, const nn::nsd::Fqdn& fqdn) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ResolveEx)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(21)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pOut, 0, (::nn::sf::Out<::nn::nsd::Fqdn>), 256, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(fqdn, 1, (const ::nn::nsd::Fqdn&), 256, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (pOut, fqdn))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pInnerResult, (::nn::nsd::InnerResult), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pInnerResult))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pInnerResult), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(fqdn)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ResolveEx)

    // nn::Result GetNasServiceSetting(nn::sf::Out<nn::nsd::NasServiceSetting> pOutNasServiceSetting, const nn::nsd::NasServiceName& nasServiceName) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNasServiceSetting)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pOutNasServiceSetting, 0, (::nn::sf::Out<::nn::nsd::NasServiceSetting>), 264, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(nasServiceName, 1, (const ::nn::nsd::NasServiceName&), 16, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (pOutNasServiceSetting, nasServiceName))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutNasServiceSetting), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(nasServiceName)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNasServiceSetting)

    // nn::Result GetNasServiceSettingEx(nn::sf::Out<nn::nsd::InnerResult> pInnerResult, nn::sf::Out<nn::nsd::NasServiceSetting> pOutNasServiceSetting, const nn::nsd::NasServiceName& nasServiceName) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNasServiceSettingEx)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(31)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pOutNasServiceSetting, 0, (::nn::sf::Out<::nn::nsd::NasServiceSetting>), 264, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(nasServiceName, 1, (const ::nn::nsd::NasServiceName&), 16, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (pOutNasServiceSetting, nasServiceName))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pInnerResult, (::nn::nsd::InnerResult), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pInnerResult))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pInnerResult), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutNasServiceSetting), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(nasServiceName)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNasServiceSettingEx)

    // nn::Result GetNasRequestFqdn(nn::sf::Out<nn::nsd::Fqdn> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNasRequestFqdn)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(40)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pOut, 0, (::nn::sf::Out<::nn::nsd::Fqdn>), 256, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNasRequestFqdn)

    // nn::Result GetNasRequestFqdnEx(nn::sf::Out<nn::nsd::InnerResult> pInnerResult, nn::sf::Out<nn::nsd::Fqdn> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNasRequestFqdnEx)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(41)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pOut, 0, (::nn::sf::Out<::nn::nsd::Fqdn>), 256, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pInnerResult, (::nn::nsd::InnerResult), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pInnerResult))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pInnerResult), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNasRequestFqdnEx)

    // nn::Result GetNasApiFqdn(nn::sf::Out<nn::nsd::Fqdn> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNasApiFqdn)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(42)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pOut, 0, (::nn::sf::Out<::nn::nsd::Fqdn>), 256, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNasApiFqdn)

    // nn::Result GetNasApiFqdnEx(nn::sf::Out<nn::nsd::InnerResult> pInnerResult, nn::sf::Out<nn::nsd::Fqdn> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNasApiFqdnEx)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(43)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pOut, 0, (::nn::sf::Out<::nn::nsd::Fqdn>), 256, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pInnerResult, (::nn::nsd::InnerResult), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pInnerResult))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pInnerResult), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNasApiFqdnEx)

    // nn::Result GetCurrentSetting(nn::sf::Out<nn::nsd::SaveData> pSaveData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetCurrentSetting)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(50)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pSaveData, 0, (::nn::sf::Out<::nn::nsd::SaveData>), 76784, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pSaveData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pSaveData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetCurrentSetting)

    // nn::Result ReadSaveDataFromFsForTest(nn::sf::Out<nn::nsd::SaveData> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ReadSaveDataFromFsForTest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(60)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pOut, 0, (::nn::sf::Out<::nn::nsd::SaveData>), 76784, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ReadSaveDataFromFsForTest)

    // nn::Result WriteSaveDataToFsForTest(const nn::nsd::SaveData& saveData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(WriteSaveDataToFsForTest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(61)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(saveData, 0, (const ::nn::nsd::SaveData&), 76784, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (saveData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(WriteSaveDataToFsForTest)

    // nn::Result DeleteSaveDataOfFsForTest() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteSaveDataOfFsForTest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(62)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteSaveDataOfFsForTest)

    // nn::Result IsChangeEnvironmentIdentifierDisabled(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsChangeEnvironmentIdentifierDisabled)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(63)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsChangeEnvironmentIdentifierDisabled)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nsd::SettingName), 256, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nsd::EnvironmentIdentifier), 8, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nsd::DeviceId), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nsd::Fqdn), 256, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nsd::InnerResult), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nsd::NasServiceSetting), 264, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nsd::NasServiceName), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nsd::SaveData), 76784, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::nsd::detail::IManager, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::nsd::detail::IManager))

    // nn::Result GetSettingName(nn::sf::Out<nn::nsd::SettingName> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSettingName, (::nn::sf::Out<::nn::nsd::SettingName> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSettingName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSettingName)
    }

    // nn::Result GetEnvironmentIdentifier(nn::sf::Out<nn::nsd::EnvironmentIdentifier> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetEnvironmentIdentifier, (::nn::sf::Out<::nn::nsd::EnvironmentIdentifier> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetEnvironmentIdentifier)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetEnvironmentIdentifier)
    }

    // nn::Result GetDeviceId(nn::sf::Out<nn::nsd::DeviceId> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDeviceId, (::nn::sf::Out<::nn::nsd::DeviceId> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDeviceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDeviceId)
    }

    // nn::Result DeleteSettings(std::int32_t deleteMode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteSettings, (::std::int32_t deleteMode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteSettings)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deleteMode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteSettings)
    }

    // nn::Result ImportSettings(const nn::sf::InBuffer& pBuffer, const nn::sf::OutBuffer& pWorkBuffer, std::int32_t importMode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ImportSettings, (const ::nn::sf::InBuffer& pBuffer, const ::nn::sf::OutBuffer& pWorkBuffer, ::std::int32_t importMode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ImportSettings)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pWorkBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(importMode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ImportSettings)
    }

    // nn::Result SetChangeEnvironmentIdentifierDisabled(bool isDisabled) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetChangeEnvironmentIdentifierDisabled, (bool isDisabled))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetChangeEnvironmentIdentifierDisabled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isDisabled)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetChangeEnvironmentIdentifierDisabled)
    }

    // nn::Result Resolve(nn::sf::Out<nn::nsd::Fqdn> pOut, const nn::nsd::Fqdn& fqdn) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Resolve, (::nn::sf::Out<::nn::nsd::Fqdn> pOut, const ::nn::nsd::Fqdn& fqdn))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Resolve)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(fqdn)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Resolve)
    }

    // nn::Result ResolveEx(nn::sf::Out<nn::nsd::InnerResult> pInnerResult, nn::sf::Out<nn::nsd::Fqdn> pOut, const nn::nsd::Fqdn& fqdn) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResolveEx, (::nn::sf::Out<::nn::nsd::InnerResult> pInnerResult, ::nn::sf::Out<::nn::nsd::Fqdn> pOut, const ::nn::nsd::Fqdn& fqdn))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ResolveEx)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pInnerResult)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(fqdn)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ResolveEx)
    }

    // nn::Result GetNasServiceSetting(nn::sf::Out<nn::nsd::NasServiceSetting> pOutNasServiceSetting, const nn::nsd::NasServiceName& nasServiceName) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNasServiceSetting, (::nn::sf::Out<::nn::nsd::NasServiceSetting> pOutNasServiceSetting, const ::nn::nsd::NasServiceName& nasServiceName))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNasServiceSetting)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutNasServiceSetting)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(nasServiceName)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNasServiceSetting)
    }

    // nn::Result GetNasServiceSettingEx(nn::sf::Out<nn::nsd::InnerResult> pInnerResult, nn::sf::Out<nn::nsd::NasServiceSetting> pOutNasServiceSetting, const nn::nsd::NasServiceName& nasServiceName) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNasServiceSettingEx, (::nn::sf::Out<::nn::nsd::InnerResult> pInnerResult, ::nn::sf::Out<::nn::nsd::NasServiceSetting> pOutNasServiceSetting, const ::nn::nsd::NasServiceName& nasServiceName))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNasServiceSettingEx)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pInnerResult)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutNasServiceSetting)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(nasServiceName)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNasServiceSettingEx)
    }

    // nn::Result GetNasRequestFqdn(nn::sf::Out<nn::nsd::Fqdn> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNasRequestFqdn, (::nn::sf::Out<::nn::nsd::Fqdn> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNasRequestFqdn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNasRequestFqdn)
    }

    // nn::Result GetNasRequestFqdnEx(nn::sf::Out<nn::nsd::InnerResult> pInnerResult, nn::sf::Out<nn::nsd::Fqdn> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNasRequestFqdnEx, (::nn::sf::Out<::nn::nsd::InnerResult> pInnerResult, ::nn::sf::Out<::nn::nsd::Fqdn> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNasRequestFqdnEx)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pInnerResult)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNasRequestFqdnEx)
    }

    // nn::Result GetNasApiFqdn(nn::sf::Out<nn::nsd::Fqdn> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNasApiFqdn, (::nn::sf::Out<::nn::nsd::Fqdn> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNasApiFqdn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNasApiFqdn)
    }

    // nn::Result GetNasApiFqdnEx(nn::sf::Out<nn::nsd::InnerResult> pInnerResult, nn::sf::Out<nn::nsd::Fqdn> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNasApiFqdnEx, (::nn::sf::Out<::nn::nsd::InnerResult> pInnerResult, ::nn::sf::Out<::nn::nsd::Fqdn> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNasApiFqdnEx)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pInnerResult)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNasApiFqdnEx)
    }

    // nn::Result GetCurrentSetting(nn::sf::Out<nn::nsd::SaveData> pSaveData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCurrentSetting, (::nn::sf::Out<::nn::nsd::SaveData> pSaveData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetCurrentSetting)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pSaveData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetCurrentSetting)
    }

    // nn::Result ReadSaveDataFromFsForTest(nn::sf::Out<nn::nsd::SaveData> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadSaveDataFromFsForTest, (::nn::sf::Out<::nn::nsd::SaveData> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ReadSaveDataFromFsForTest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ReadSaveDataFromFsForTest)
    }

    // nn::Result WriteSaveDataToFsForTest(const nn::nsd::SaveData& saveData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WriteSaveDataToFsForTest, (const ::nn::nsd::SaveData& saveData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(WriteSaveDataToFsForTest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(WriteSaveDataToFsForTest)
    }

    // nn::Result DeleteSaveDataOfFsForTest() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeleteSaveDataOfFsForTest)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteSaveDataOfFsForTest)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteSaveDataOfFsForTest)
    }

    // nn::Result IsChangeEnvironmentIdentifierDisabled(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsChangeEnvironmentIdentifierDisabled, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsChangeEnvironmentIdentifierDisabled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsChangeEnvironmentIdentifierDisabled)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::nsd::detail::IManager>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::nsd::detail::IManager))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSettingName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSettingName)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetEnvironmentIdentifier)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetEnvironmentIdentifier)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDeviceId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDeviceId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteSettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteSettings)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deleteMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ImportSettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pBuffer)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pWorkBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ImportSettings)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pWorkBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(importMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetChangeEnvironmentIdentifierDisabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetChangeEnvironmentIdentifierDisabled)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isDisabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Resolve)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOut)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(fqdn)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Resolve)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(fqdn)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ResolveEx)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOut)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(fqdn)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ResolveEx)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pInnerResult),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(fqdn)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNasServiceSetting)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutNasServiceSetting)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(nasServiceName)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNasServiceSetting)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutNasServiceSetting),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(nasServiceName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNasServiceSettingEx)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutNasServiceSetting)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(nasServiceName)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNasServiceSettingEx)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pInnerResult),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutNasServiceSetting),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(nasServiceName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNasRequestFqdn)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNasRequestFqdn)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNasRequestFqdnEx)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNasRequestFqdnEx)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pInnerResult),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNasApiFqdn)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNasApiFqdn)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNasApiFqdnEx)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNasApiFqdnEx)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pInnerResult),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetCurrentSetting)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pSaveData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetCurrentSetting)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pSaveData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ReadSaveDataFromFsForTest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ReadSaveDataFromFsForTest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(WriteSaveDataToFsForTest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(saveData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(WriteSaveDataToFsForTest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(saveData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteSaveDataOfFsForTest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteSaveDataOfFsForTest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsChangeEnvironmentIdentifierDisabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsChangeEnvironmentIdentifierDisabled)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSettingName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetEnvironmentIdentifier)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDeviceId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteSettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ImportSettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetChangeEnvironmentIdentifierDisabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Resolve)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ResolveEx)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNasServiceSetting)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNasServiceSettingEx)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNasRequestFqdn)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNasRequestFqdnEx)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNasApiFqdn)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNasApiFqdnEx)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetCurrentSetting)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ReadSaveDataFromFsForTest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(WriteSaveDataToFsForTest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteSaveDataOfFsForTest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsChangeEnvironmentIdentifierDisabled)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::nsd::detail::IManager))
