﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief メニュー向けの内部実装 API
 */

#pragma once

#include <nn/nsd/nsd_Common.h>
#include <nn/nsd/nsd_DeleteMode.h>
#include <nn/nsd/nsd_ImportMode.h>

namespace nn { namespace nsd { namespace detail {

    nn::Result GetSettingName(SettingName* pOut) NN_NOEXCEPT;

    nn::Result GetEnvironmentIdentifier(EnvironmentIdentifier* pOut) NN_NOEXCEPT;

    nn::Result DeleteSettings(DeleteMode deleteMode) NN_NOEXCEPT;

    nn::Result ImportSettings(
        const void* pBuffer, size_t bufferSize,
        void* pWorkBuffer, size_t workBufferSize,
        ImportMode importMode) NN_NOEXCEPT;

    bool IsChangeEnvironmentIdentifierDisabled() NN_NOEXCEPT;

    void SetChangeEnvironmentIdentifierDisabled(bool isDisabled) NN_NOEXCEPT;

}}} // nn::nsd::detail
