﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nsd/nsd_Types.h>
#include <nn/nsd/nsd_TypesPrivate.h>

//
// デバイス情報的なことを扱うものをここへ集める
//

namespace nn { namespace nsd { namespace detail { namespace device {

    /**
     * @brief 自身のデバイス情報を取得
     * @param[out] pOut   デバイス情報
     * @pre
     *  - pOut != nullptr
     */
    void LoadOwnDeviceId(DeviceId* pOut) NN_NOEXCEPT;

    /**
     * @brief settings から環境識別子を取得する
     * @return 取得した環境識別子
     * @details
     */
    EnvironmentIdentifier& GetEnvironmentIdentifierFromSettings() NN_NOEXCEPT;

}}}} // nn::nsd::detail::device
