﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Mutex.h>
#include <nn/util/util_Optional.h>
#include <nn/ncm/ncm_PackageSystemUpdateTask.h>
#include <nn/os/os_TransferMemory.h>
#include <nn/ns/ns_SystemDeliveryInfo.h>
#include <nn/ns/detail/ns_IAsync.sfdl.h>
#include <nn/ns/detail/ns_ISystemUpdateInterface.sfdl.h>
#include <nn/ns/srv/ns_DataStore.h>
#include <nn/ns/srv/ns_ExFatDriverManager.h>
#include <nn/ns/srv/ns_OsUtil.h>
#include <nn/ns/srv/ns_SystemUpdateApplyManager.h>
#include <nn/ns/srv/ns_SystemUpdateRequest.h>
#include <nn/ns/srv/ns_SystemReportManager.h>

namespace nn { namespace ns { namespace srv {

    class SystemUpdateInterfaceServer;

    class SystemUpdateControlServer
    {
    public:
        explicit SystemUpdateControlServer(SystemUpdateInterfaceServer* server, RequestServer::ManagedStop&& managedStop) NN_NOEXCEPT : m_Server(server), m_ManagedStop(std::move(managedStop)), m_IsCardUpdateSetup(), m_IsAlreadyCardUpdateRequested() {}
        ~SystemUpdateControlServer() NN_NOEXCEPT;

        Result HasDownloaded(sf::Out<bool> outValue) NN_NOEXCEPT;
        Result RequestCheckLatestUpdate(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<ns::detail::IAsyncValue>> outAsync) NN_NOEXCEPT;
        Result RequestDownloadLatestUpdate(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<ns::detail::IAsyncResult>> outAsync) NN_NOEXCEPT;
        Result GetDownloadProgress(sf::Out<SystemUpdateProgress> outValue) NN_NOEXCEPT;
        Result ApplyDownloadedUpdate() NN_NOEXCEPT;
        Result SetupCardUpdate(sf::NativeHandle&& transferMemoryHandle, std::uint64_t transferMemorySize) NN_NOEXCEPT;
        Result RequestPrepareCardUpdate(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<ns::detail::IAsyncResult>> outAsync) NN_NOEXCEPT;
        Result GetPrepareCardUpdateProgress(sf::Out<SystemUpdateProgress> outValue) NN_NOEXCEPT;
        Result HasPreparedCardUpdate(sf::Out<bool> outValue) NN_NOEXCEPT;
        Result ApplyCardUpdate() NN_NOEXCEPT;
        Result SetupCardUpdateViaSystemUpdater(sf::NativeHandle&& transferMemoryHandle, std::uint64_t transferMemorySize) NN_NOEXCEPT;
        Result GetDownloadedEulaDataSize(sf::Out<std::uint64_t> outValue, const ns::detail::EulaDataPath& path) NN_NOEXCEPT;
        Result GetDownloadedEulaData(sf::Out<std::uint64_t> outValue, const sf::OutBuffer& buffer, const ns::detail::EulaDataPath& path) NN_NOEXCEPT;
        Result GetPreparedCardUpdateEulaDataSize(sf::Out<std::uint64_t> outValue, const ns::detail::EulaDataPath& path) NN_NOEXCEPT;
        Result GetPreparedCardUpdateEulaData(sf::Out<std::uint64_t> outValue, const sf::OutBuffer& buffer, const ns::detail::EulaDataPath& path) NN_NOEXCEPT;

        Result HasReceived(sf::Out<bool> outValue) NN_NOEXCEPT;
        Result SetupToReceiveSystemUpdate() NN_NOEXCEPT;
        Result RequestReceiveSystemUpdate(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<ns::detail::IAsyncResult>> outAsync, uint32_t ipv4, uint16_t port, const SystemDeliveryInfo& info) NN_NOEXCEPT;
        Result GetReceiveProgress(sf::Out<SystemUpdateProgress> outValue) NN_NOEXCEPT;
        Result ApplyReceivedUpdate() NN_NOEXCEPT;
        Result GetReceivedEulaDataSize(sf::Out<std::uint64_t> outValue, const ns::detail::EulaDataPath& path) NN_NOEXCEPT;
        Result GetReceivedEulaData(sf::Out<std::uint64_t> outValue, const sf::OutBuffer& buffer, const ns::detail::EulaDataPath& path) NN_NOEXCEPT;

    private:
        Result MountPreparedCardUpdateEulaData(const char* mountName) NN_NOEXCEPT;
        Result InitializeCardUpdateTask(sf::NativeHandle&& transferMemoryHandle, std::uint64_t transferMemorySize) NN_NOEXCEPT;

        SystemUpdateInterfaceServer* m_Server;
        RequestServer::ManagedStop m_ManagedStop;

        bool m_IsCardUpdateSetup;
        bool m_IsAlreadyCardUpdateRequested;
        util::optional<ncm::PackageSystemUpdateTask> m_CardUpdateTask;
        util::optional<os::TransferMemory> m_CardUpdateTransferMemory;
    };

    class SystemUpdateInterfaceServer
    {
    public:
        SystemUpdateInterfaceServer() NN_NOEXCEPT;
        ~SystemUpdateInterfaceServer() NN_NOEXCEPT;
        Result Initialize(SystemReportManager* systemReportManager) NN_NOEXCEPT;
        Result GetBackgroundNetworkUpdateState(sf::Out<BackgroundNetworkUpdateState> outValue) NN_NOEXCEPT;
        Result OpenSystemUpdateControl(sf::Out<sf::SharedPointer<ns::detail::ISystemUpdateControl>> outValue) NN_NOEXCEPT;
        Result NotifyExFatDriverRequired() NN_NOEXCEPT;
        Result NotifyExFatDriverDownloaded() NN_NOEXCEPT;
        Result NotifyExFatDriverDownloadedForDebug() NN_NOEXCEPT
        {
            return NotifyExFatDriverDownloaded();
        }
        Result ClearExFatDriverStatusForDebug() NN_NOEXCEPT;
        Result RequestBackgroundNetworkUpdate() NN_NOEXCEPT;
        Result NotifyBackgroundNetworkUpdate(const nn::ncm::ContentMetaKey& systemUpdateMetaKey) NN_NOEXCEPT;

        bool IsExFatDriverRequired() NN_NOEXCEPT
        {
            return m_ExFatDriverManager.IsDriverRequired();
        }

        bool IsExFatDriverDownloadedAtLeastOnce() NN_NOEXCEPT
        {
            return m_ExFatDriverManager.IsDriverDownloadedAtLeastOnce();
        }

        Result GetBackgroundNetworkUpdateIdleEvent(sf::Out<sf::NativeHandle> outValue) NN_NOEXCEPT;
        Result SignalBackgroundNetworkUpdateIdleEventForDebug() NN_NOEXCEPT;

        Result GetSystemUpdateNotificationEventForContentDelivery(sf::Out<sf::NativeHandle> outValue) NN_NOEXCEPT;
        Result NotifySystemUpdateForContentDelivery() NN_NOEXCEPT;

        void OnCloseSystemUpdateControl() NN_NOEXCEPT;
        RequestServer* GetRequestServer() NN_NOEXCEPT
        {
            return &m_RequestServer;
        }
        Result PrepareShutdown() NN_NOEXCEPT;

        Result DestroySystemUpdateTask() NN_NOEXCEPT;

        Result RequestSendSystemUpdate(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<ns::detail::IAsyncResult>> outAsync, uint32_t ipv4, uint16_t port, const SystemDeliveryInfo& info) NN_NOEXCEPT;
        Result GetSendSystemUpdateProgress(sf::Out<SystemUpdateProgress> outValue) NN_NOEXCEPT;
        Result ApplySystemUpdateTask(nim::SystemUpdateTaskId id) NN_NOEXCEPT;
        Result ApplyReceivedSystemUpdateTask(nim::LocalCommunicationReceiveSystemUpdateTaskId id) NN_NOEXCEPT;
        Result ApplyPackageSystemUpdateTask(ncm::PackageSystemUpdateTask* task) NN_NOEXCEPT;

    private:
        Result CleanupOnForceShutdown() NN_NOEXCEPT;
        Result DestroyIncompleteSystemUpdateTask() NN_NOEXCEPT;

        NonRecursiveMutex m_OccupationMutex;
        bool m_IsControlServerOccupied;
        DataStore m_DataStore;
        ExFatDriverManager m_ExFatDriverManager;
        SystemUpdateApplyManager m_SystemUpdateApplyManager;
        SystemUpdateRequestList m_RequestList;
        RequestServer m_RequestServer;
        ManualClearSystemEvent m_EventForContentDelivery;
        RequestServer::ManagedStop m_Stopper;
    };

}}}
