﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os/os_MessageQueue.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/ns/srv/ns_Shell.h>
#include <nn/lmem/lmem_UnitHeap.h>
#include <nn/ns/ns_ApplicationManagerSystemApi.h>

namespace nn { namespace ns { namespace srv {

    class ApplicationShellEventObserver : public IShellEventObserver
    {
    public:
        ApplicationShellEventObserver() NN_NOEXCEPT;
        int PopApplicationShellEventInfo(ApplicationShellEventInfo outList[], int count) NN_NOEXCEPT;
        os::SystemEvent& GetEvent() NN_NOEXCEPT
        {
            return m_Event;
        }
        void RequestReboot() NN_NOEXCEPT;
        void NotifyStartCardUpdate() NN_NOEXCEPT;
        void RequestShowCardUpdateProcessing() NN_NOEXCEPT;
        void NotifyEndCardUpdate() NN_NOEXCEPT;

    private:
        virtual void Notify(const pm::ProcessEventInfo& info) NN_NOEXCEPT NN_OVERRIDE;
        void NotifyImpl(const ApplicationShellEventInfo& appInfo) NN_NOEXCEPT;
        static const int MaxQueueCount = 32;

        os::MessageQueue m_MessageQueue;
        uintptr_t m_QueueBuffer[MaxQueueCount];
        os::SystemEvent m_Event;
        lmem::HeapCommonHead m_HeapHead;
        lmem::HeapHandle m_HeapHandle;
        ApplicationShellEventInfo m_EventInfoData[MaxQueueCount];
    };

}}}  // namespace nn::ns::srv

