﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/pm/pm_BootModeApi.h>
#include <nn/ns/detail/ns_IApplicationManagerInterface.sfdl.h>
#include <nn/ns/srv/ns_ApplicationShellEventObserver.h>

namespace nn { namespace ns { namespace srv {
    class AppletLauncher
    {
    public:
        AppletLauncher() NN_NOEXCEPT : m_IsLaunchSystemAppletEnabled(true), m_IsLaunchOverlayAppletEnabled(true), m_ObserverHolder(&m_Observer) {}

        void Initialize(pm::BootMode bootMode) NN_NOEXCEPT
        {
            m_BootMode = bootMode;
            RegisterShellEventObserver(&m_ObserverHolder);
        }

        void Finalize() NN_NOEXCEPT
        {
            UnregisterShellEventObserver(&m_ObserverHolder);
        }

        void SetLaunchSystemAppletEnabled(bool isOn) NN_NOEXCEPT
        {
            m_IsLaunchSystemAppletEnabled = isOn;
        }

        void SetLaunchOverlayAppletEnabled(bool isOn) NN_NOEXCEPT
        {
            m_IsLaunchOverlayAppletEnabled = isOn;
        }

        Result GetApplicationShellEvent(sf::Out<sf::NativeHandle> outValue) NN_NOEXCEPT;
        Result PopApplicationShellEventInfo(sf::Out<std::int32_t> outCount, const sf::OutArray<ns::ApplicationShellEventInfo>& outList) NN_NOEXCEPT;
        Result LaunchLibraryApplet(sf::Out<os::ProcessId> outValue, ncm::SystemProgramId id) NN_NOEXCEPT;
        Result TerminateLibraryApplet(os::ProcessId pid) NN_NOEXCEPT;
        Result LaunchSystemApplet(sf::Out<os::ProcessId> outValue) NN_NOEXCEPT;
        Result TerminateSystemApplet(os::ProcessId pid) NN_NOEXCEPT;
        Result LaunchOverlayApplet(sf::Out<os::ProcessId> outValue) NN_NOEXCEPT;
        Result TerminateOverlayApplet(os::ProcessId pid) NN_NOEXCEPT;

        void RequestReboot() NN_NOEXCEPT;
        void NotifyStartCardUpdate() NN_NOEXCEPT;
        void RequestShowCardUpdateProcessing() NN_NOEXCEPT;
        void NotifyEndCardUpdate() NN_NOEXCEPT;

    private:
        pm::BootMode m_BootMode;
        bool m_IsLaunchSystemAppletEnabled;
        bool m_IsLaunchOverlayAppletEnabled;
        ShellEventObserverHolder m_ObserverHolder;
        ApplicationShellEventObserver m_Observer;
    };

}}} // ~namespace ns::srv

