﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ns/detail/ns_ISystemUpdateInterface.sfdl.h>
#include <nn/ns/ns_Async.h>
#include <nn/ns/ns_SystemUpdateApi.h>
#include <nn/ncm/ncm_ContentMetaKey.h>

namespace nn { namespace ns {
    void InitializeForSystemUpdateWithObject(sf::SharedPointer<nn::ns::detail::ISystemUpdateInterface> interfac) NN_NOEXCEPT;

    Result NotifyExFatDriverRequired() NN_NOEXCEPT;

    Result NotifyExFatDriverDownloaded() NN_NOEXCEPT;

    Result ClearExFatDriverStatus() NN_NOEXCEPT;

    Result RequestBackgroundNetworkUpdate() NN_NOEXCEPT;

    Result NotifyBackgroundNetworkUpdate(const ncm::ContentMetaKey& systemUpdateMetaKey) NN_NOEXCEPT;

    void NotifySystemUpdateForContentDelivery() NN_NOEXCEPT;

    Result DestroySystemUpdateTask() NN_NOEXCEPT;

    Result RequestSendSystemUpdate(AsyncResult* outValue, uint32_t ipv4, uint16_t port, const SystemDeliveryInfo& info) NN_NOEXCEPT;

    SystemUpdateProgress GetSendSystemUpdateProgress() NN_NOEXCEPT;
}}
