﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ncm/ncm_StorageId.h>
#include <nn/ncm/ncm_SubmissionPackageInstallTask.h>
#include <nn/ncm/ncm_ContentMetaDatabase.h>
#include <nn/ncm/ncm_ContentStorage.h>

namespace nn { namespace ns {

    class ApplicationInstallTask : public ncm::SubmissionPackageInstallTask
    {
    public:
        ApplicationInstallTask() NN_NOEXCEPT {}
        virtual ~ApplicationInstallTask() NN_NOEXCEPT {}

        Result Initialize(fs::FileHandle file, ncm::StorageId storage, void* buffer, size_t bufferSize, bool ignoreTicket = false) NN_NOEXCEPT;
        Result Commit() NN_NOEXCEPT;

    private:
        Result PostCommit() NN_NOEXCEPT;

        ncm::ContentMetaDatabase m_Db;
        ncm::ContentStorage m_Storage;
    };

}}  // namespace nn::ns

