﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ns/ns_ApplicationRightsTypes.h>
#include <nn/ns/ns_Async.h>

namespace nn { namespace ns {

    typedef ApplicationRightsOnServerFlag::Flag<0>  ApplicationRightsOnServerFlag_HasAvailableRights;
    typedef ApplicationRightsOnServerFlag::Flag<1>  ApplicationRightsOnServerFlag_HasUnavailableRights;
    typedef ApplicationRightsOnServerFlag::Flag<2>  ApplicationRightsOnServerFlag_IsAccountRestrictedRights;
    typedef ApplicationRightsOnServerFlag::Flag<3>  ApplicationRightsOnServerFlag_RecommendSyncTicket;
    typedef ApplicationRightsOnServerFlag::Flag<4>  ApplicationRightsOnServerFlag_RecommendAssignRights;

    // ライセンスタイプ
    typedef ApplicationRightsOnServerFlag::Flag<5>  ApplicationRightsOnServerFlag_DeviceLinkedPermanentLicense;
    typedef ApplicationRightsOnServerFlag::Flag<6>  ApplicationRightsOnServerFlag_PermanentLicense;
    typedef ApplicationRightsOnServerFlag::Flag<7>  ApplicationRightsOnServerFlag_AccountRestrictivePermanentLicense;
    typedef ApplicationRightsOnServerFlag::Flag<8>  ApplicationRightsOnServerFlag_TemporaryLicense;

    typedef ApplicationRightsUnavailableFlag::Flag<0>  ApplicationRightsUnavailableFlag_NoRights;
    typedef ApplicationRightsUnavailableFlag::Flag<1>  ApplicationRightsUnavailableFlag_SystemUpdateRequired;
    typedef ApplicationRightsUnavailableFlag::Flag<2>  ApplicationRightsUnavailableFlag_HasDeviceLinkedRightsOnlyContent;
    typedef ApplicationRightsUnavailableFlag::Flag<3>  ApplicationRightsUnavailableFlag_NotReleased;
    typedef ApplicationRightsUnavailableFlag::Flag<4>  ApplicationRightsUnavailableFlag_AssignableRightsLimitExceeded;

    enum ApplicationRightsQueryFlagTag {};
    typedef util::BitFlagSet<32, ApplicationRightsQueryFlagTag>      ApplicationRightsQueryFlags;
    typedef ApplicationRightsQueryFlags::Flag<0>    ApplicationRightsQueryFlag_Application;
    typedef ApplicationRightsQueryFlags::Flag<1>    ApplicationRightsQueryFlag_AddOnContent;

}}  // namespace nn::ns
