﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn { namespace ns {

    /**
    * @brief    指定されたアプリケーション記録のアプリケーションドキュメントをマウントします。
    *
    * @details  内部で fs API を呼び出すため、fs のアロケータが適切に設定されている必要があります。
    *
    * @return   処理の結果が返ります。メディアアクセスエラーなどは下位レイヤの Result が返されます。必要があればエラーコードを表示してください。
    * @retval   ResultApplicationRecordNotFound         指定されたアプリケーション記録が見つかりません。
    * @retval   ResultApplicationContentNotFound       指定されたアプリケーションにアプリケーションドキュメントがありません。
    *
    * @pre
    *           - InitializeForApplicationManager が呼び出されている
    *
    * @post
    *           - mountName でアプリケーションドキュメントがマウントされている
    */
    Result MountApplicationHtmlDocument(const char* mountName, ncm::ApplicationId id) NN_NOEXCEPT;

    /**
    * @brief    指定されたアプリケーション記録のソフトリーガル情報をマウントします。
    *
    * @details  内部で fs API を呼び出すため、fs のアロケータが適切に設定されている必要があります。
    *
    * @return   処理の結果が返ります。メディアアクセスエラーなどは下位レイヤの Result が返されます。必要があればエラーコードを表示してください。
    * @retval   ResultApplicationRecordNotFound         指定されたアプリケーション記録が見つかりません。
    * @retval   ResultApplicationContentNotFound  指定されたアプリケーションにソフトリーガル情報がありません。
    *
    * @pre
    *           - InitializeForApplicationManager が呼び出されている
    *
    * @post
    *           - mountName でソフトリーガル情報がマウントされている
    */
    Result MountApplicationLegalInformation(const char* mountName, ncm::ApplicationId id) NN_NOEXCEPT;

}}  // namespace nn::ns
