﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_StaticAssert.h>

namespace nn { namespace ns {
    struct ReceiveApplicationProgress
    {
        int64_t downloadedSize;
        int64_t totalSize;
    };
    NN_STATIC_ASSERT(sizeof(ReceiveApplicationProgress) == 16);

    struct SendApplicationProgress
    {
        int64_t sentSize;
        int64_t totalSize;
    };
    NN_STATIC_ASSERT(sizeof(SendApplicationProgress) == 16);

}}  // namespace ns
