﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/ns/ns_Async.h>

namespace nn { namespace ns {

    /**
    * @brief    バージョンリストの取得を要求します。
    */
    void RequestVersionList() NN_NOEXCEPT;

    Result UpdateVersionList(const char* buffer, size_t size) NN_NOEXCEPT;

    void PushLaunchVersion(ncm::ApplicationId id, uint32_t version) NN_NOEXCEPT;

    struct RequiredVersionEntry
    {
        Bit64           id;
        uint32_t        requiredVersion;
        Bit8            reserved[4];
    };

    int ListRequiredVersion(RequiredVersionEntry* outValue, int count) NN_NOEXCEPT;

    struct VersionListEntry
    {
        nn::Bit64           id;
        uint32_t            recommendedVersion;
        uint32_t            notifiedVersion;
    };

    int ListVersionList(VersionListEntry* outValue, int count) NN_NOEXCEPT;

    struct VersionListData
    {
        char data[256 * 1024];
    };

    typedef AsyncValue<VersionListData> AsyncVersionListData;
    Result RequestVersionListData(AsyncVersionListData* outValue) NN_NOEXCEPT;

    /**
    *   @brief      指定したアプリケーションの起動必須バージョンを取得します。
    *
    *   @param[in]  id   対象のアプリケーション
    *
    *   @return     対象のアプリケーションの起動必須バージョン。
    */
    uint32_t GetLaunchRequiredVersion(ncm::ApplicationId id) NN_NOEXCEPT;

    /**
    *   @brief      指定したアプリケーションの起動必須バージョンを引き上げます。
    *
    *   @details    指定したアプリケーションの起動必須バージョンを引き上げます。
    *               現在の起動必須バージョンが launchRequiredVersion で指定した値以上の場合は、
    *               起動必須バージョンの更新は行われません。
    *
    *   @param[in]  id                      対象のアプリケーション
    *   @param[in]  launchRequiredVersion   起動必須バージョン
    *
    *   @return     なし。
    */
    void UpgradeLaunchRequiredVersion(ncm::ApplicationId id, uint32_t launchRequiredVersion) NN_NOEXCEPT;

    void PerformAutoUpdate() NN_NOEXCEPT;
}}  // namespace nn::ns
