﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/ncm/ncm_ContentMetaKey.h>
#include <nn/ncm/ncm_SystemContentMetaId.h>
#include <nn/nn_Result.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace ns { namespace detail { // NOLINT(whitespace/braces)

class IVulnerabilityManagerInterface;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IVulnerabilityManagerInterface, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IVulnerabilityManagerInterface)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(NeedsUpdateVulnerability, (::nn::sf::Out<bool> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UpdateSafeSystemVersionForDebug, (::nn::ncm::SystemUpdateId systemUpdateId, ::std::uint32_t version))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSafeSystemVersion, (::nn::sf::Out<::nn::ncm::ContentMetaKey> outValue))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IVulnerabilityManagerInterface)

        ::nn::Result NeedsUpdateVulnerability(::nn::sf::Out<bool> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(NeedsUpdateVulnerability, (outValue));
        }

        ::nn::Result UpdateSafeSystemVersionForDebug(::nn::ncm::SystemUpdateId systemUpdateId, ::std::uint32_t version) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UpdateSafeSystemVersionForDebug, (systemUpdateId, version));
        }

        ::nn::Result GetSafeSystemVersion(::nn::sf::Out<::nn::ncm::ContentMetaKey> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSafeSystemVersion, (outValue));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IVulnerabilityManagerInterface
    {
    public:
        nn::Result NeedsUpdateVulnerability(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
        nn::Result UpdateSafeSystemVersionForDebug(nn::ncm::SystemUpdateId systemUpdateId, std::uint32_t version) NN_NOEXCEPT;
        nn::Result GetSafeSystemVersion(nn::sf::Out<nn::ncm::ContentMetaKey> outValue) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result NeedsUpdateVulnerability(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
    nn::Result UpdateSafeSystemVersionForDebug(nn::ncm::SystemUpdateId systemUpdateId, std::uint32_t version) NN_NOEXCEPT;
    nn::Result GetSafeSystemVersion(nn::sf::Out<nn::ncm::ContentMetaKey> outValue) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::ns::detail::IVulnerabilityManagerInterface))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(NeedsUpdateVulnerability, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(NeedsUpdateVulnerability, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UpdateSafeSystemVersionForDebug, (::nn::ncm::SystemUpdateId systemUpdateId, ::std::uint32_t version))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UpdateSafeSystemVersionForDebug, (systemUpdateId, version));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSafeSystemVersion, (::nn::sf::Out<::nn::ncm::ContentMetaKey> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSafeSystemVersion, (outValue));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::ns::detail::IVulnerabilityManagerInterface>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::ns::detail::IVulnerabilityManagerInterface))

    // nn::Result NeedsUpdateVulnerability(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(NeedsUpdateVulnerability)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1200)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(NeedsUpdateVulnerability)

    // nn::Result UpdateSafeSystemVersionForDebug(nn::ncm::SystemUpdateId systemUpdateId, std::uint32_t version) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UpdateSafeSystemVersionForDebug)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1201)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(version, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(systemUpdateId, (::nn::ncm::SystemUpdateId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (version, systemUpdateId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(systemUpdateId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(version)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UpdateSafeSystemVersionForDebug)

    // nn::Result GetSafeSystemVersion(nn::sf::Out<nn::ncm::ContentMetaKey> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSafeSystemVersion)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1202)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::ncm::ContentMetaKey), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSafeSystemVersion)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::SystemUpdateId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ContentMetaKey), 16, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::ns::detail::IVulnerabilityManagerInterface, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::ns::detail::IVulnerabilityManagerInterface))

    // nn::Result NeedsUpdateVulnerability(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(NeedsUpdateVulnerability, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(NeedsUpdateVulnerability)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(NeedsUpdateVulnerability)
    }

    // nn::Result UpdateSafeSystemVersionForDebug(nn::ncm::SystemUpdateId systemUpdateId, std::uint32_t version) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UpdateSafeSystemVersionForDebug, (::nn::ncm::SystemUpdateId systemUpdateId, ::std::uint32_t version))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UpdateSafeSystemVersionForDebug)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(systemUpdateId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(version)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UpdateSafeSystemVersionForDebug)
    }

    // nn::Result GetSafeSystemVersion(nn::sf::Out<nn::ncm::ContentMetaKey> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSafeSystemVersion, (::nn::sf::Out<::nn::ncm::ContentMetaKey> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSafeSystemVersion)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSafeSystemVersion)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::ns::detail::IVulnerabilityManagerInterface>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::ns::detail::IVulnerabilityManagerInterface))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(NeedsUpdateVulnerability)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(NeedsUpdateVulnerability)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UpdateSafeSystemVersionForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UpdateSafeSystemVersionForDebug)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(systemUpdateId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(version)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSafeSystemVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSafeSystemVersion)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(NeedsUpdateVulnerability)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UpdateSafeSystemVersionForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSafeSystemVersion)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::ns::detail::IVulnerabilityManagerInterface))
