﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/ncm/ncm_ProgramId.h>
#include <nn/ncm/ncm_StorageId.h>
#include <nn/nn_Result.h>
#include <nn/ns/ns_DevelopApi.h>
#include <nn/os/os_Types.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace ns { namespace detail { // NOLINT(whitespace/braces)

class IDevelopInterface;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IDevelopInterface, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IDevelopInterface)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LaunchProgram, (::nn::sf::Out<::nn::os::ProcessId> pOut, const ::nn::ns::ProgramLaunchProperty& launchProperty, ::std::int32_t flags))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(TerminateProcess, (::nn::os::ProcessId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(TerminateProgram, (::nn::ncm::ProgramId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetShellEventHandle, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetShellEventInfo, (::nn::sf::Out<::nn::ns::ShellEventInfo> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(TerminateApplication)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(PrepareLaunchProgramFromHost, (::nn::sf::Out<::nn::ns::ProgramLaunchProperty> launchProperty, const ::nn::sf::InBuffer& programPath))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LaunchApplication, (::nn::sf::Out<::nn::os::ProcessId> pOut, ::nn::ncm::ApplicationId applicationId, ::std::int32_t flags))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LaunchApplicationWithStorageId, (::nn::sf::Out<::nn::os::ProcessId> pOut, ::nn::ncm::ApplicationId applicationId, ::std::int32_t flags, ::nn::ncm::StorageId appStorageId, ::nn::ncm::StorageId patchStorageId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsSystemMemoryResourceLimitBoosted, (::nn::sf::Out<bool> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetRunningApplicationProcessId, (::nn::sf::Out<::nn::os::ProcessId> pOut))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IDevelopInterface)

        ::nn::Result LaunchProgram(::nn::sf::Out<::nn::os::ProcessId> pOut, const ::nn::ns::ProgramLaunchProperty& launchProperty, ::std::int32_t flags) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LaunchProgram, (pOut, launchProperty, flags));
        }

        ::nn::Result TerminateProcess(::nn::os::ProcessId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(TerminateProcess, (id));
        }

        ::nn::Result TerminateProgram(::nn::ncm::ProgramId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(TerminateProgram, (id));
        }

        ::nn::Result GetShellEventHandle(::nn::sf::Out<::nn::sf::NativeHandle> handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetShellEventHandle, (handle));
        }

        ::nn::Result GetShellEventInfo(::nn::sf::Out<::nn::ns::ShellEventInfo> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetShellEventInfo, (pOut));
        }

        ::nn::Result TerminateApplication() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(TerminateApplication);
        }

        ::nn::Result PrepareLaunchProgramFromHost(::nn::sf::Out<::nn::ns::ProgramLaunchProperty> launchProperty, const ::nn::sf::InBuffer& programPath) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(PrepareLaunchProgramFromHost, (launchProperty, programPath));
        }

        ::nn::Result LaunchApplication(::nn::sf::Out<::nn::os::ProcessId> pOut, ::nn::ncm::ApplicationId applicationId, ::std::int32_t flags) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LaunchApplication, (pOut, applicationId, flags));
        }

        ::nn::Result LaunchApplicationWithStorageId(::nn::sf::Out<::nn::os::ProcessId> pOut, ::nn::ncm::ApplicationId applicationId, ::std::int32_t flags, ::nn::ncm::StorageId appStorageId, ::nn::ncm::StorageId patchStorageId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LaunchApplicationWithStorageId, (pOut, applicationId, flags, appStorageId, patchStorageId));
        }

        ::nn::Result IsSystemMemoryResourceLimitBoosted(::nn::sf::Out<bool> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsSystemMemoryResourceLimitBoosted, (pOut));
        }

        ::nn::Result GetRunningApplicationProcessId(::nn::sf::Out<::nn::os::ProcessId> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetRunningApplicationProcessId, (pOut));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IDevelopInterface
    {
    public:
        nn::Result LaunchProgram(nn::sf::Out<nn::os::ProcessId> pOut, const nn::ns::ProgramLaunchProperty& launchProperty, std::int32_t flags) NN_NOEXCEPT;
        nn::Result TerminateProcess(nn::os::ProcessId id) NN_NOEXCEPT;
        nn::Result TerminateProgram(nn::ncm::ProgramId id) NN_NOEXCEPT;
        nn::Result GetShellEventHandle(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
        nn::Result GetShellEventInfo(nn::sf::Out<nn::ns::ShellEventInfo> pOut) NN_NOEXCEPT;
        nn::Result TerminateApplication() NN_NOEXCEPT;
        nn::Result PrepareLaunchProgramFromHost(nn::sf::Out<nn::ns::ProgramLaunchProperty> launchProperty, const nn::sf::InBuffer& programPath) NN_NOEXCEPT;
        nn::Result LaunchApplication(nn::sf::Out<nn::os::ProcessId> pOut, nn::ncm::ApplicationId applicationId, std::int32_t flags) NN_NOEXCEPT;
        nn::Result LaunchApplicationWithStorageId(nn::sf::Out<nn::os::ProcessId> pOut, nn::ncm::ApplicationId applicationId, std::int32_t flags, nn::ncm::StorageId appStorageId, nn::ncm::StorageId patchStorageId) NN_NOEXCEPT;
        nn::Result IsSystemMemoryResourceLimitBoosted(nn::sf::Out<bool> pOut) NN_NOEXCEPT;
        nn::Result GetRunningApplicationProcessId(nn::sf::Out<nn::os::ProcessId> pOut) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result LaunchProgram(nn::sf::Out<nn::os::ProcessId> pOut, const nn::ns::ProgramLaunchProperty& launchProperty, std::int32_t flags) NN_NOEXCEPT;
    nn::Result TerminateProcess(nn::os::ProcessId id) NN_NOEXCEPT;
    nn::Result TerminateProgram(nn::ncm::ProgramId id) NN_NOEXCEPT;
    nn::Result GetShellEventHandle(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    nn::Result GetShellEventInfo(nn::sf::Out<nn::ns::ShellEventInfo> pOut) NN_NOEXCEPT;
    nn::Result TerminateApplication() NN_NOEXCEPT;
    nn::Result PrepareLaunchProgramFromHost(nn::sf::Out<nn::ns::ProgramLaunchProperty> launchProperty, const nn::sf::InBuffer& programPath) NN_NOEXCEPT;
    nn::Result LaunchApplication(nn::sf::Out<nn::os::ProcessId> pOut, nn::ncm::ApplicationId applicationId, std::int32_t flags) NN_NOEXCEPT;
    nn::Result LaunchApplicationWithStorageId(nn::sf::Out<nn::os::ProcessId> pOut, nn::ncm::ApplicationId applicationId, std::int32_t flags, nn::ncm::StorageId appStorageId, nn::ncm::StorageId patchStorageId) NN_NOEXCEPT;
    nn::Result IsSystemMemoryResourceLimitBoosted(nn::sf::Out<bool> pOut) NN_NOEXCEPT;
    nn::Result GetRunningApplicationProcessId(nn::sf::Out<nn::os::ProcessId> pOut) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::ns::detail::IDevelopInterface))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LaunchProgram, (::nn::sf::Out<::nn::os::ProcessId> pOut, const ::nn::ns::ProgramLaunchProperty& launchProperty, ::std::int32_t flags))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LaunchProgram, (pOut, launchProperty, flags));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TerminateProcess, (::nn::os::ProcessId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(TerminateProcess, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TerminateProgram, (::nn::ncm::ProgramId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(TerminateProgram, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetShellEventHandle, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetShellEventHandle, (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetShellEventInfo, (::nn::sf::Out<::nn::ns::ShellEventInfo> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetShellEventInfo, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(TerminateApplication)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(TerminateApplication);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PrepareLaunchProgramFromHost, (::nn::sf::Out<::nn::ns::ProgramLaunchProperty> launchProperty, const ::nn::sf::InBuffer& programPath))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(PrepareLaunchProgramFromHost, (launchProperty, programPath));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LaunchApplication, (::nn::sf::Out<::nn::os::ProcessId> pOut, ::nn::ncm::ApplicationId applicationId, ::std::int32_t flags))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LaunchApplication, (pOut, applicationId, flags));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LaunchApplicationWithStorageId, (::nn::sf::Out<::nn::os::ProcessId> pOut, ::nn::ncm::ApplicationId applicationId, ::std::int32_t flags, ::nn::ncm::StorageId appStorageId, ::nn::ncm::StorageId patchStorageId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LaunchApplicationWithStorageId, (pOut, applicationId, flags, appStorageId, patchStorageId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsSystemMemoryResourceLimitBoosted, (::nn::sf::Out<bool> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsSystemMemoryResourceLimitBoosted, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRunningApplicationProcessId, (::nn::sf::Out<::nn::os::ProcessId> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetRunningApplicationProcessId, (pOut));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::ns::detail::IDevelopInterface>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::ns::detail::IDevelopInterface))

    // nn::Result LaunchProgram(nn::sf::Out<nn::os::ProcessId> pOut, const nn::ns::ProgramLaunchProperty& launchProperty, std::int32_t flags) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LaunchProgram)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(flags, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(launchProperty, (::nn::ns::ProgramLaunchProperty), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (flags, launchProperty))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (::nn::os::ProcessId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(launchProperty), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(flags)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LaunchProgram)

    // nn::Result TerminateProcess(nn::os::ProcessId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(TerminateProcess)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::os::ProcessId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(TerminateProcess)

    // nn::Result TerminateProgram(nn::ncm::ProgramId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(TerminateProgram)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ProgramId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(TerminateProgram)

    // nn::Result GetShellEventHandle(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetShellEventHandle)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetShellEventHandle)

    // nn::Result GetShellEventInfo(nn::sf::Out<nn::ns::ShellEventInfo> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetShellEventInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (::nn::ns::ShellEventInfo), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetShellEventInfo)

    // nn::Result TerminateApplication() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(TerminateApplication)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(TerminateApplication)

    // nn::Result PrepareLaunchProgramFromHost(nn::sf::Out<nn::ns::ProgramLaunchProperty> launchProperty, const nn::sf::InBuffer& programPath) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(PrepareLaunchProgramFromHost)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(programPath, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (programPath))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(launchProperty, (::nn::ns::ProgramLaunchProperty), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (launchProperty))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(launchProperty), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(programPath)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(PrepareLaunchProgramFromHost)

    // nn::Result LaunchApplication(nn::sf::Out<nn::os::ProcessId> pOut, nn::ncm::ApplicationId applicationId, std::int32_t flags) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LaunchApplication)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(flags, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(applicationId, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (flags, applicationId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (::nn::os::ProcessId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(applicationId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(flags)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LaunchApplication)

    // nn::Result LaunchApplicationWithStorageId(nn::sf::Out<nn::os::ProcessId> pOut, nn::ncm::ApplicationId applicationId, std::int32_t flags, nn::ncm::StorageId appStorageId, nn::ncm::StorageId patchStorageId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LaunchApplicationWithStorageId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appStorageId, (::nn::ncm::StorageId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(patchStorageId, (::nn::ncm::StorageId), 1)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(flags, (::std::int32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(applicationId, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (appStorageId, patchStorageId, flags, applicationId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (::nn::os::ProcessId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(applicationId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(flags), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appStorageId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(patchStorageId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LaunchApplicationWithStorageId)

    // nn::Result IsSystemMemoryResourceLimitBoosted(nn::sf::Out<bool> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsSystemMemoryResourceLimitBoosted)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsSystemMemoryResourceLimitBoosted)

    // nn::Result GetRunningApplicationProcessId(nn::sf::Out<nn::os::ProcessId> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetRunningApplicationProcessId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (::nn::os::ProcessId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetRunningApplicationProcessId)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::ProgramLaunchProperty), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ProgramId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::ShellEventInfo), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ApplicationId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::StorageId), 1, 1)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::ns::detail::IDevelopInterface, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::ns::detail::IDevelopInterface))

    // nn::Result LaunchProgram(nn::sf::Out<nn::os::ProcessId> pOut, const nn::ns::ProgramLaunchProperty& launchProperty, std::int32_t flags) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LaunchProgram, (::nn::sf::Out<::nn::os::ProcessId> pOut, const ::nn::ns::ProgramLaunchProperty& launchProperty, ::std::int32_t flags))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LaunchProgram)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(launchProperty)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(flags)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LaunchProgram)
    }

    // nn::Result TerminateProcess(nn::os::ProcessId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TerminateProcess, (::nn::os::ProcessId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(TerminateProcess)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(TerminateProcess)
    }

    // nn::Result TerminateProgram(nn::ncm::ProgramId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TerminateProgram, (::nn::ncm::ProgramId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(TerminateProgram)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(TerminateProgram)
    }

    // nn::Result GetShellEventHandle(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetShellEventHandle, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetShellEventHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetShellEventHandle)
    }

    // nn::Result GetShellEventInfo(nn::sf::Out<nn::ns::ShellEventInfo> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetShellEventInfo, (::nn::sf::Out<::nn::ns::ShellEventInfo> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetShellEventInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetShellEventInfo)
    }

    // nn::Result TerminateApplication() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(TerminateApplication)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(TerminateApplication)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(TerminateApplication)
    }

    // nn::Result PrepareLaunchProgramFromHost(nn::sf::Out<nn::ns::ProgramLaunchProperty> launchProperty, const nn::sf::InBuffer& programPath) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PrepareLaunchProgramFromHost, (::nn::sf::Out<::nn::ns::ProgramLaunchProperty> launchProperty, const ::nn::sf::InBuffer& programPath))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(PrepareLaunchProgramFromHost)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(launchProperty)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(programPath)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(PrepareLaunchProgramFromHost)
    }

    // nn::Result LaunchApplication(nn::sf::Out<nn::os::ProcessId> pOut, nn::ncm::ApplicationId applicationId, std::int32_t flags) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LaunchApplication, (::nn::sf::Out<::nn::os::ProcessId> pOut, ::nn::ncm::ApplicationId applicationId, ::std::int32_t flags))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LaunchApplication)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(applicationId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(flags)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LaunchApplication)
    }

    // nn::Result LaunchApplicationWithStorageId(nn::sf::Out<nn::os::ProcessId> pOut, nn::ncm::ApplicationId applicationId, std::int32_t flags, nn::ncm::StorageId appStorageId, nn::ncm::StorageId patchStorageId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LaunchApplicationWithStorageId, (::nn::sf::Out<::nn::os::ProcessId> pOut, ::nn::ncm::ApplicationId applicationId, ::std::int32_t flags, ::nn::ncm::StorageId appStorageId, ::nn::ncm::StorageId patchStorageId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LaunchApplicationWithStorageId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(applicationId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(flags)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appStorageId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(patchStorageId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LaunchApplicationWithStorageId)
    }

    // nn::Result IsSystemMemoryResourceLimitBoosted(nn::sf::Out<bool> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsSystemMemoryResourceLimitBoosted, (::nn::sf::Out<bool> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsSystemMemoryResourceLimitBoosted)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsSystemMemoryResourceLimitBoosted)
    }

    // nn::Result GetRunningApplicationProcessId(nn::sf::Out<nn::os::ProcessId> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRunningApplicationProcessId, (::nn::sf::Out<::nn::os::ProcessId> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetRunningApplicationProcessId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetRunningApplicationProcessId)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::ns::detail::IDevelopInterface>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::ns::detail::IDevelopInterface))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LaunchProgram)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LaunchProgram)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(launchProperty),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(flags)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(TerminateProcess)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(TerminateProcess)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(TerminateProgram)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(TerminateProgram)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetShellEventHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetShellEventHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetShellEventInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetShellEventInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(TerminateApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(TerminateApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(PrepareLaunchProgramFromHost)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(programPath)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(PrepareLaunchProgramFromHost)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(launchProperty),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(programPath)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LaunchApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LaunchApplication)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(applicationId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(flags)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LaunchApplicationWithStorageId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LaunchApplicationWithStorageId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(applicationId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(flags),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appStorageId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(patchStorageId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsSystemMemoryResourceLimitBoosted)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsSystemMemoryResourceLimitBoosted)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetRunningApplicationProcessId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetRunningApplicationProcessId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LaunchProgram)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(TerminateProcess)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(TerminateProgram)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetShellEventHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetShellEventInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(TerminateApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(PrepareLaunchProgramFromHost)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LaunchApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LaunchApplicationWithStorageId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsSystemMemoryResourceLimitBoosted)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetRunningApplicationProcessId)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::ns::detail::IDevelopInterface))
