﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/account/account_Types.h>
#include <nn/nn_ApplicationId.h>
#include <nn/nn_BitTypes.h>
#include <nn/nn_Result.h>
#include <nn/nn_TimeSpan.h>
#include <nn/npns/npns_Types.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace npns { // NOLINT(whitespace/braces)

class INpnsSystem;

class INpnsUser;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(INpnsUser, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(INpnsUser)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ListenAll)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListenTo, (::nn::ApplicationId toId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Receive, (const ::nn::sf::OutBuffer& outBuffer, ::std::uint16_t version))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ReceiveRaw, (const ::nn::sf::OutBuffer& outBuffer, ::std::uint16_t version))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetReceiveEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetStateChangeEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateToken, (::nn::sf::Out<::nn::npns::NotificationToken> outToken, const ::nn::account::Uid& uid, ::nn::Bit64 processId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DestroyToken, (const ::nn::account::Uid& uid, ::nn::Bit64 processId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(QueryIsTokenValid, (::nn::sf::Out<bool> bResult, const ::nn::npns::NotificationToken& token))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListenToMyApplicationId, (::nn::Bit64 processId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(Suspend)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(Resume)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetState, (::nn::sf::Out<::std::int32_t> outState))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetStatistics, (const ::nn::sf::OutBuffer& outStatistics))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetJid, (const ::nn::sf::OutArray<char>& jid))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(INpnsUser)

        ::nn::Result ListenAll() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ListenAll);
        }

        ::nn::Result ListenTo(::nn::ApplicationId toId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListenTo, (toId));
        }

        ::nn::Result Receive(const ::nn::sf::OutBuffer& outBuffer, ::std::uint16_t version) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Receive, (outBuffer, version));
        }

        ::nn::Result ReceiveRaw(const ::nn::sf::OutBuffer& outBuffer, ::std::uint16_t version) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ReceiveRaw, (outBuffer, version));
        }

        ::nn::Result GetReceiveEvent(::nn::sf::Out<::nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetReceiveEvent, (outHandle));
        }

        ::nn::Result GetStateChangeEvent(::nn::sf::Out<::nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetStateChangeEvent, (outHandle));
        }

        ::nn::Result CreateToken(::nn::sf::Out<::nn::npns::NotificationToken> outToken, const ::nn::account::Uid& uid, ::nn::Bit64 processId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateToken, (outToken, uid, processId));
        }

        ::nn::Result DestroyToken(const ::nn::account::Uid& uid, ::nn::Bit64 processId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DestroyToken, (uid, processId));
        }

        ::nn::Result QueryIsTokenValid(::nn::sf::Out<bool> bResult, const ::nn::npns::NotificationToken& token) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(QueryIsTokenValid, (bResult, token));
        }

        ::nn::Result ListenToMyApplicationId(::nn::Bit64 processId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListenToMyApplicationId, (processId));
        }

        ::nn::Result Suspend() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(Suspend);
        }

        ::nn::Result Resume() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(Resume);
        }

        ::nn::Result GetState(::nn::sf::Out<::std::int32_t> outState) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetState, (outState));
        }

        ::nn::Result GetStatistics(const ::nn::sf::OutBuffer& outStatistics) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetStatistics, (outStatistics));
        }

        ::nn::Result GetJid(const ::nn::sf::OutArray<char>& jid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetJid, (jid));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class INpnsUser
    {
    public:
        nn::Result ListenAll() NN_NOEXCEPT;
        nn::Result ListenTo(nn::ApplicationId toId) NN_NOEXCEPT;
        nn::Result Receive(const nn::sf::OutBuffer& outBuffer, std::uint16_t version) NN_NOEXCEPT;
        nn::Result ReceiveRaw(const nn::sf::OutBuffer& outBuffer, std::uint16_t version) NN_NOEXCEPT;
        nn::Result GetReceiveEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
        nn::Result GetStateChangeEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
        nn::Result CreateToken(nn::sf::Out<nn::npns::NotificationToken> outToken, const nn::account::Uid& uid, nn::Bit64 processId) NN_NOEXCEPT;
        nn::Result DestroyToken(const nn::account::Uid& uid, nn::Bit64 processId) NN_NOEXCEPT;
        nn::Result QueryIsTokenValid(nn::sf::Out<bool> bResult, const nn::npns::NotificationToken& token) NN_NOEXCEPT;
        nn::Result ListenToMyApplicationId(nn::Bit64 processId) NN_NOEXCEPT;
        nn::Result Suspend() NN_NOEXCEPT;
        nn::Result Resume() NN_NOEXCEPT;
        nn::Result GetState(nn::sf::Out<std::int32_t> outState) NN_NOEXCEPT;
        nn::Result GetStatistics(const nn::sf::OutBuffer& outStatistics) NN_NOEXCEPT;
        nn::Result GetJid(const nn::sf::OutArray<char>& jid) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result ListenAll() NN_NOEXCEPT;
    nn::Result ListenTo(nn::ApplicationId toId) NN_NOEXCEPT;
    nn::Result Receive(const nn::sf::OutBuffer& outBuffer, std::uint16_t version) NN_NOEXCEPT;
    nn::Result ReceiveRaw(const nn::sf::OutBuffer& outBuffer, std::uint16_t version) NN_NOEXCEPT;
    nn::Result GetReceiveEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
    nn::Result GetStateChangeEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
    nn::Result CreateToken(nn::sf::Out<nn::npns::NotificationToken> outToken, const nn::account::Uid& uid, nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result DestroyToken(const nn::account::Uid& uid, nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result QueryIsTokenValid(nn::sf::Out<bool> bResult, const nn::npns::NotificationToken& token) NN_NOEXCEPT;
    nn::Result ListenToMyApplicationId(nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result Suspend() NN_NOEXCEPT;
    nn::Result Resume() NN_NOEXCEPT;
    nn::Result GetState(nn::sf::Out<std::int32_t> outState) NN_NOEXCEPT;
    nn::Result GetStatistics(const nn::sf::OutBuffer& outStatistics) NN_NOEXCEPT;
    nn::Result GetJid(const nn::sf::OutArray<char>& jid) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::npns::INpnsUser))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ListenAll)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ListenAll);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListenTo, (::nn::ApplicationId toId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListenTo, (toId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Receive, (const ::nn::sf::OutBuffer& outBuffer, ::std::uint16_t version))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Receive, (outBuffer, version));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReceiveRaw, (const ::nn::sf::OutBuffer& outBuffer, ::std::uint16_t version))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ReceiveRaw, (outBuffer, version));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetReceiveEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetReceiveEvent, (outHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetStateChangeEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetStateChangeEvent, (outHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateToken, (::nn::sf::Out<::nn::npns::NotificationToken> outToken, const ::nn::account::Uid& uid, ::nn::Bit64 processId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateToken, (outToken, uid, processId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyToken, (const ::nn::account::Uid& uid, ::nn::Bit64 processId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DestroyToken, (uid, processId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryIsTokenValid, (::nn::sf::Out<bool> bResult, const ::nn::npns::NotificationToken& token))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(QueryIsTokenValid, (bResult, token));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListenToMyApplicationId, (::nn::Bit64 processId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListenToMyApplicationId, (processId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Suspend)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(Suspend);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Resume)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(Resume);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetState, (::nn::sf::Out<::std::int32_t> outState))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetState, (outState));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetStatistics, (const ::nn::sf::OutBuffer& outStatistics))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetStatistics, (outStatistics));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetJid, (const ::nn::sf::OutArray<char>& jid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetJid, (jid));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::npns::INpnsUser>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::npns::INpnsUser))

    // nn::Result ListenAll() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListenAll)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListenAll)

    // nn::Result ListenTo(nn::ApplicationId toId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListenTo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(toId, (::nn::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (toId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(toId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListenTo)

    // nn::Result Receive(const nn::sf::OutBuffer& outBuffer, std::uint16_t version) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Receive)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(version, (::std::uint16_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (version))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(version)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Receive)

    // nn::Result ReceiveRaw(const nn::sf::OutBuffer& outBuffer, std::uint16_t version) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ReceiveRaw)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(version, (::std::uint16_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (version))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(version)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ReceiveRaw)

    // nn::Result GetReceiveEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetReceiveEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetReceiveEvent)

    // nn::Result GetStateChangeEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetStateChangeEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetStateChangeEvent)

    // nn::Result CreateToken(nn::sf::Out<nn::npns::NotificationToken> outToken, const nn::account::Uid& uid, nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateToken)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(21)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(processId, (::nn::Bit64), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (uid, processId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outToken, (::nn::npns::NotificationToken), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outToken))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(40)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outToken), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateToken)

    // nn::Result DestroyToken(const nn::account::Uid& uid, nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DestroyToken)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(23)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(processId, (::nn::Bit64), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (uid, processId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DestroyToken)

    // nn::Result QueryIsTokenValid(nn::sf::Out<bool> bResult, const nn::npns::NotificationToken& token) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(QueryIsTokenValid)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(25)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(token, (::nn::npns::NotificationToken), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (token))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(40)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(bResult, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (bResult))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bResult), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(token)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(QueryIsTokenValid)

    // nn::Result ListenToMyApplicationId(nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListenToMyApplicationId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(26)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(processId, (::nn::Bit64), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (processId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListenToMyApplicationId)

    // nn::Result Suspend() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Suspend)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(101)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Suspend)

    // nn::Result Resume() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Resume)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(102)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Resume)

    // nn::Result GetState(nn::sf::Out<std::int32_t> outState) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(103)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outState, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outState))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outState)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetState)

    // nn::Result GetStatistics(const nn::sf::OutBuffer& outStatistics) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetStatistics)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(104)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outStatistics, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outStatistics))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outStatistics)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetStatistics)

    // nn::Result GetJid(const nn::sf::OutArray<char>& jid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetJid)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(111)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(jid, 0, (const ::nn::sf::OutArray<char>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (jid))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(jid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetJid)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ApplicationId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::npns::NotificationToken), 40, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::Uid), 16, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::npns::INpnsUser, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::npns::INpnsUser))

    // nn::Result ListenAll() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ListenAll)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListenAll)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListenAll)
    }

    // nn::Result ListenTo(nn::ApplicationId toId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListenTo, (::nn::ApplicationId toId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListenTo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(toId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListenTo)
    }

    // nn::Result Receive(const nn::sf::OutBuffer& outBuffer, std::uint16_t version) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Receive, (const ::nn::sf::OutBuffer& outBuffer, ::std::uint16_t version))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Receive)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(version)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Receive)
    }

    // nn::Result ReceiveRaw(const nn::sf::OutBuffer& outBuffer, std::uint16_t version) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReceiveRaw, (const ::nn::sf::OutBuffer& outBuffer, ::std::uint16_t version))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ReceiveRaw)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(version)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ReceiveRaw)
    }

    // nn::Result GetReceiveEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetReceiveEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetReceiveEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetReceiveEvent)
    }

    // nn::Result GetStateChangeEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetStateChangeEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetStateChangeEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetStateChangeEvent)
    }

    // nn::Result CreateToken(nn::sf::Out<nn::npns::NotificationToken> outToken, const nn::account::Uid& uid, nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateToken, (::nn::sf::Out<::nn::npns::NotificationToken> outToken, const ::nn::account::Uid& uid, ::nn::Bit64 processId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateToken)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outToken)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateToken)
    }

    // nn::Result DestroyToken(const nn::account::Uid& uid, nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyToken, (const ::nn::account::Uid& uid, ::nn::Bit64 processId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DestroyToken)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DestroyToken)
    }

    // nn::Result QueryIsTokenValid(nn::sf::Out<bool> bResult, const nn::npns::NotificationToken& token) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryIsTokenValid, (::nn::sf::Out<bool> bResult, const ::nn::npns::NotificationToken& token))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(QueryIsTokenValid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bResult)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(token)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(QueryIsTokenValid)
    }

    // nn::Result ListenToMyApplicationId(nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListenToMyApplicationId, (::nn::Bit64 processId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListenToMyApplicationId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListenToMyApplicationId)
    }

    // nn::Result Suspend() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Suspend)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Suspend)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Suspend)
    }

    // nn::Result Resume() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Resume)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Resume)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Resume)
    }

    // nn::Result GetState(nn::sf::Out<std::int32_t> outState) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetState, (::nn::sf::Out<::std::int32_t> outState))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outState)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetState)
    }

    // nn::Result GetStatistics(const nn::sf::OutBuffer& outStatistics) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetStatistics, (const ::nn::sf::OutBuffer& outStatistics))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetStatistics)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outStatistics)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetStatistics)
    }

    // nn::Result GetJid(const nn::sf::OutArray<char>& jid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetJid, (const ::nn::sf::OutArray<char>& jid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetJid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(jid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetJid)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::npns::INpnsUser>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::npns::INpnsUser))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListenAll)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListenAll)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListenTo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListenTo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(toId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Receive)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Receive)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(version)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ReceiveRaw)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ReceiveRaw)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(version)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetReceiveEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetReceiveEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetStateChangeEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetStateChangeEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateToken)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateToken)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outToken),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DestroyToken)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DestroyToken)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(QueryIsTokenValid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(QueryIsTokenValid)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(bResult),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(token)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListenToMyApplicationId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListenToMyApplicationId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Suspend)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Suspend)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Resume)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Resume)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetStatistics)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outStatistics)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetStatistics)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outStatistics)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetJid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(jid)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetJid)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(jid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListenAll)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListenTo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Receive)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ReceiveRaw)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetReceiveEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetStateChangeEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateToken)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DestroyToken)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(QueryIsTokenValid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListenToMyApplicationId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Suspend)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Resume)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetStatistics)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetJid)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::npns::INpnsUser))

namespace nn { namespace npns { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(INpnsSystem, (::nn::npns::INpnsUser))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(INpnsSystem)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ListenUndelivered)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SubscribeTopic, (const ::nn::sf::InArray<char>& name))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UnsubscribeTopic, (const ::nn::sf::InArray<char>& name))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(QueryIsTopicExist, (::nn::sf::Out<bool> bResult, const ::nn::sf::InArray<char>& name))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateTokenWithApplicationId, (::nn::sf::Out<::nn::npns::NotificationToken> outToken, const ::nn::account::Uid& uid, ::nn::ApplicationId applicationId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DestroyTokenWithApplicationId, (const ::nn::account::Uid& uid, ::nn::ApplicationId applicationId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UploadTokenToBaaS, (const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DestroyTokenForBaaS, (const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetPlayReportRequestEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(CreateJid)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DestroyJid)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AttachJid, (const ::nn::sf::InArray<char>& jid, const ::nn::sf::InArray<char>& password))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DetachJid, (const ::nn::sf::OutArray<char>& jid, const ::nn::sf::OutArray<char>& password))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestChangeStateForceTimed, (::std::int32_t targetState, ::nn::TimeSpanType timeout))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestChangeStateForceAsync, (::std::int32_t targetState))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(INpnsSystem)

        ::nn::Result ListenUndelivered() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ListenUndelivered);
        }

        ::nn::Result SubscribeTopic(const ::nn::sf::InArray<char>& name) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SubscribeTopic, (name));
        }

        ::nn::Result UnsubscribeTopic(const ::nn::sf::InArray<char>& name) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UnsubscribeTopic, (name));
        }

        ::nn::Result QueryIsTopicExist(::nn::sf::Out<bool> bResult, const ::nn::sf::InArray<char>& name) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(QueryIsTopicExist, (bResult, name));
        }

        ::nn::Result CreateTokenWithApplicationId(::nn::sf::Out<::nn::npns::NotificationToken> outToken, const ::nn::account::Uid& uid, ::nn::ApplicationId applicationId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateTokenWithApplicationId, (outToken, uid, applicationId));
        }

        ::nn::Result DestroyTokenWithApplicationId(const ::nn::account::Uid& uid, ::nn::ApplicationId applicationId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DestroyTokenWithApplicationId, (uid, applicationId));
        }

        ::nn::Result UploadTokenToBaaS(const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UploadTokenToBaaS, (uid));
        }

        ::nn::Result DestroyTokenForBaaS(const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DestroyTokenForBaaS, (uid));
        }

        ::nn::Result GetPlayReportRequestEvent(::nn::sf::Out<::nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetPlayReportRequestEvent, (outHandle));
        }

        ::nn::Result CreateJid() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(CreateJid);
        }

        ::nn::Result DestroyJid() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DestroyJid);
        }

        ::nn::Result AttachJid(const ::nn::sf::InArray<char>& jid, const ::nn::sf::InArray<char>& password) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AttachJid, (jid, password));
        }

        ::nn::Result DetachJid(const ::nn::sf::OutArray<char>& jid, const ::nn::sf::OutArray<char>& password) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DetachJid, (jid, password));
        }

        ::nn::Result RequestChangeStateForceTimed(::std::int32_t targetState, ::nn::TimeSpanType timeout) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestChangeStateForceTimed, (targetState, timeout));
        }

        ::nn::Result RequestChangeStateForceAsync(::std::int32_t targetState) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestChangeStateForceAsync, (targetState));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class INpnsSystem : public ::nn::npns::INpnsUser
    {
    public:
        nn::Result ListenUndelivered() NN_NOEXCEPT;
        nn::Result SubscribeTopic(const nn::sf::InArray<char>& name) NN_NOEXCEPT;
        nn::Result UnsubscribeTopic(const nn::sf::InArray<char>& name) NN_NOEXCEPT;
        nn::Result QueryIsTopicExist(nn::sf::Out<bool> bResult, const nn::sf::InArray<char>& name) NN_NOEXCEPT;
        nn::Result CreateTokenWithApplicationId(nn::sf::Out<nn::npns::NotificationToken> outToken, const nn::account::Uid& uid, nn::ApplicationId applicationId) NN_NOEXCEPT;
        nn::Result DestroyTokenWithApplicationId(const nn::account::Uid& uid, nn::ApplicationId applicationId) NN_NOEXCEPT;
        nn::Result UploadTokenToBaaS(const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result DestroyTokenForBaaS(const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result GetPlayReportRequestEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
        nn::Result CreateJid() NN_NOEXCEPT;
        nn::Result DestroyJid() NN_NOEXCEPT;
        nn::Result AttachJid(const nn::sf::InArray<char>& jid, const nn::sf::InArray<char>& password) NN_NOEXCEPT;
        nn::Result DetachJid(const nn::sf::OutArray<char>& jid, const nn::sf::OutArray<char>& password) NN_NOEXCEPT;
        nn::Result RequestChangeStateForceTimed(std::int32_t targetState, nn::TimeSpanType timeout) NN_NOEXCEPT;
        nn::Result RequestChangeStateForceAsync(std::int32_t targetState) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result ListenAll() NN_NOEXCEPT;
    nn::Result ListenTo(nn::ApplicationId toId) NN_NOEXCEPT;
    nn::Result Receive(const nn::sf::OutBuffer& outBuffer, std::uint16_t version) NN_NOEXCEPT;
    nn::Result ReceiveRaw(const nn::sf::OutBuffer& outBuffer, std::uint16_t version) NN_NOEXCEPT;
    nn::Result GetReceiveEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
    nn::Result ListenUndelivered() NN_NOEXCEPT;
    nn::Result GetStateChangeEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
    nn::Result SubscribeTopic(const nn::sf::InArray<char>& name) NN_NOEXCEPT;
    nn::Result UnsubscribeTopic(const nn::sf::InArray<char>& name) NN_NOEXCEPT;
    nn::Result QueryIsTopicExist(nn::sf::Out<bool> bResult, const nn::sf::InArray<char>& name) NN_NOEXCEPT;
    nn::Result CreateToken(nn::sf::Out<nn::npns::NotificationToken> outToken, const nn::account::Uid& uid, nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result CreateTokenWithApplicationId(nn::sf::Out<nn::npns::NotificationToken> outToken, const nn::account::Uid& uid, nn::ApplicationId applicationId) NN_NOEXCEPT;
    nn::Result DestroyToken(const nn::account::Uid& uid, nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result DestroyTokenWithApplicationId(const nn::account::Uid& uid, nn::ApplicationId applicationId) NN_NOEXCEPT;
    nn::Result QueryIsTokenValid(nn::sf::Out<bool> bResult, const nn::npns::NotificationToken& token) NN_NOEXCEPT;
    nn::Result ListenToMyApplicationId(nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result UploadTokenToBaaS(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result DestroyTokenForBaaS(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result Suspend() NN_NOEXCEPT;
    nn::Result Resume() NN_NOEXCEPT;
    nn::Result GetState(nn::sf::Out<std::int32_t> outState) NN_NOEXCEPT;
    nn::Result GetStatistics(const nn::sf::OutBuffer& outStatistics) NN_NOEXCEPT;
    nn::Result GetPlayReportRequestEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
    nn::Result GetJid(const nn::sf::OutArray<char>& jid) NN_NOEXCEPT;
    nn::Result CreateJid() NN_NOEXCEPT;
    nn::Result DestroyJid() NN_NOEXCEPT;
    nn::Result AttachJid(const nn::sf::InArray<char>& jid, const nn::sf::InArray<char>& password) NN_NOEXCEPT;
    nn::Result DetachJid(const nn::sf::OutArray<char>& jid, const nn::sf::OutArray<char>& password) NN_NOEXCEPT;
    nn::Result RequestChangeStateForceTimed(std::int32_t targetState, nn::TimeSpanType timeout) NN_NOEXCEPT;
    nn::Result RequestChangeStateForceAsync(std::int32_t targetState) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_WITH_BASE((::nn::npns::INpnsSystem), (::nn::npns::INpnsUser))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ListenUndelivered)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ListenUndelivered);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SubscribeTopic, (const ::nn::sf::InArray<char>& name))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SubscribeTopic, (name));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnsubscribeTopic, (const ::nn::sf::InArray<char>& name))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UnsubscribeTopic, (name));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryIsTopicExist, (::nn::sf::Out<bool> bResult, const ::nn::sf::InArray<char>& name))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(QueryIsTopicExist, (bResult, name));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateTokenWithApplicationId, (::nn::sf::Out<::nn::npns::NotificationToken> outToken, const ::nn::account::Uid& uid, ::nn::ApplicationId applicationId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateTokenWithApplicationId, (outToken, uid, applicationId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyTokenWithApplicationId, (const ::nn::account::Uid& uid, ::nn::ApplicationId applicationId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DestroyTokenWithApplicationId, (uid, applicationId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UploadTokenToBaaS, (const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UploadTokenToBaaS, (uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyTokenForBaaS, (const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DestroyTokenForBaaS, (uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPlayReportRequestEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetPlayReportRequestEvent, (outHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CreateJid)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(CreateJid);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DestroyJid)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DestroyJid);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AttachJid, (const ::nn::sf::InArray<char>& jid, const ::nn::sf::InArray<char>& password))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AttachJid, (jid, password));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DetachJid, (const ::nn::sf::OutArray<char>& jid, const ::nn::sf::OutArray<char>& password))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DetachJid, (jid, password));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestChangeStateForceTimed, (::std::int32_t targetState, ::nn::TimeSpanType timeout))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestChangeStateForceTimed, (targetState, timeout));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestChangeStateForceAsync, (::std::int32_t targetState))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestChangeStateForceAsync, (targetState));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::npns::INpnsSystem>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_WITH_BASE((::nn::npns::INpnsSystem), (::nn::npns::INpnsUser))

    // nn::Result ListenUndelivered() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListenUndelivered)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListenUndelivered)

    // nn::Result SubscribeTopic(const nn::sf::InArray<char>& name) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SubscribeTopic)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(name, 0, (const ::nn::sf::InArray<char>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (name))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(name)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SubscribeTopic)

    // nn::Result UnsubscribeTopic(const nn::sf::InArray<char>& name) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnsubscribeTopic)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(name, 0, (const ::nn::sf::InArray<char>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (name))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(name)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnsubscribeTopic)

    // nn::Result QueryIsTopicExist(nn::sf::Out<bool> bResult, const nn::sf::InArray<char>& name) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(QueryIsTopicExist)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(name, 0, (const ::nn::sf::InArray<char>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (name))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(bResult, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (bResult))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bResult), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(name)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(QueryIsTopicExist)

    // nn::Result CreateTokenWithApplicationId(nn::sf::Out<nn::npns::NotificationToken> outToken, const nn::account::Uid& uid, nn::ApplicationId applicationId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateTokenWithApplicationId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(22)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(applicationId, (::nn::ApplicationId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (uid, applicationId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outToken, (::nn::npns::NotificationToken), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outToken))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(40)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outToken), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(applicationId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateTokenWithApplicationId)

    // nn::Result DestroyTokenWithApplicationId(const nn::account::Uid& uid, nn::ApplicationId applicationId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DestroyTokenWithApplicationId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(applicationId, (::nn::ApplicationId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (uid, applicationId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(applicationId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DestroyTokenWithApplicationId)

    // nn::Result UploadTokenToBaaS(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UploadTokenToBaaS)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(31)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UploadTokenToBaaS)

    // nn::Result DestroyTokenForBaaS(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DestroyTokenForBaaS)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(32)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DestroyTokenForBaaS)

    // nn::Result GetPlayReportRequestEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetPlayReportRequestEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(105)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetPlayReportRequestEvent)

    // nn::Result CreateJid() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateJid)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(112)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateJid)

    // nn::Result DestroyJid() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DestroyJid)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(113)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DestroyJid)

    // nn::Result AttachJid(const nn::sf::InArray<char>& jid, const nn::sf::InArray<char>& password) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AttachJid)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(114)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(jid, 0, (const ::nn::sf::InArray<char>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(password, 1, (const ::nn::sf::InArray<char>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (jid, password))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(jid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(password)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AttachJid)

    // nn::Result DetachJid(const nn::sf::OutArray<char>& jid, const nn::sf::OutArray<char>& password) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DetachJid)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(115)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(jid, 0, (const ::nn::sf::OutArray<char>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(password, 1, (const ::nn::sf::OutArray<char>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (jid, password))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(jid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(password)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DetachJid)

    // nn::Result RequestChangeStateForceTimed(std::int32_t targetState, nn::TimeSpanType timeout) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestChangeStateForceTimed)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(201)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(targetState, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(timeout, (::nn::TimeSpanType), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (targetState, timeout))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(targetState), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(timeout)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestChangeStateForceTimed)

    // nn::Result RequestChangeStateForceAsync(std::int32_t targetState) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestChangeStateForceAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(202)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(targetState, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (targetState))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(targetState)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestChangeStateForceAsync)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ApplicationId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::npns::NotificationToken), 40, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::Uid), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::TimeSpanType), 8, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::npns::INpnsSystem, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_WITH_BASE((::nn::npns::INpnsSystem), (::nn::npns::INpnsUser))

    // nn::Result ListenUndelivered() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ListenUndelivered)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListenUndelivered)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListenUndelivered)
    }

    // nn::Result SubscribeTopic(const nn::sf::InArray<char>& name) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SubscribeTopic, (const ::nn::sf::InArray<char>& name))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SubscribeTopic)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(name)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SubscribeTopic)
    }

    // nn::Result UnsubscribeTopic(const nn::sf::InArray<char>& name) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnsubscribeTopic, (const ::nn::sf::InArray<char>& name))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnsubscribeTopic)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(name)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnsubscribeTopic)
    }

    // nn::Result QueryIsTopicExist(nn::sf::Out<bool> bResult, const nn::sf::InArray<char>& name) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryIsTopicExist, (::nn::sf::Out<bool> bResult, const ::nn::sf::InArray<char>& name))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(QueryIsTopicExist)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bResult)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(name)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(QueryIsTopicExist)
    }

    // nn::Result CreateTokenWithApplicationId(nn::sf::Out<nn::npns::NotificationToken> outToken, const nn::account::Uid& uid, nn::ApplicationId applicationId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateTokenWithApplicationId, (::nn::sf::Out<::nn::npns::NotificationToken> outToken, const ::nn::account::Uid& uid, ::nn::ApplicationId applicationId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateTokenWithApplicationId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outToken)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(applicationId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateTokenWithApplicationId)
    }

    // nn::Result DestroyTokenWithApplicationId(const nn::account::Uid& uid, nn::ApplicationId applicationId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyTokenWithApplicationId, (const ::nn::account::Uid& uid, ::nn::ApplicationId applicationId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DestroyTokenWithApplicationId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(applicationId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DestroyTokenWithApplicationId)
    }

    // nn::Result UploadTokenToBaaS(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UploadTokenToBaaS, (const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UploadTokenToBaaS)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UploadTokenToBaaS)
    }

    // nn::Result DestroyTokenForBaaS(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyTokenForBaaS, (const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DestroyTokenForBaaS)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DestroyTokenForBaaS)
    }

    // nn::Result GetPlayReportRequestEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPlayReportRequestEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetPlayReportRequestEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetPlayReportRequestEvent)
    }

    // nn::Result CreateJid() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CreateJid)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateJid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateJid)
    }

    // nn::Result DestroyJid() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DestroyJid)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DestroyJid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DestroyJid)
    }

    // nn::Result AttachJid(const nn::sf::InArray<char>& jid, const nn::sf::InArray<char>& password) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AttachJid, (const ::nn::sf::InArray<char>& jid, const ::nn::sf::InArray<char>& password))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AttachJid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(jid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(password)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AttachJid)
    }

    // nn::Result DetachJid(const nn::sf::OutArray<char>& jid, const nn::sf::OutArray<char>& password) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DetachJid, (const ::nn::sf::OutArray<char>& jid, const ::nn::sf::OutArray<char>& password))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DetachJid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(jid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(password)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DetachJid)
    }

    // nn::Result RequestChangeStateForceTimed(std::int32_t targetState, nn::TimeSpanType timeout) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestChangeStateForceTimed, (::std::int32_t targetState, ::nn::TimeSpanType timeout))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestChangeStateForceTimed)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(targetState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(timeout)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestChangeStateForceTimed)
    }

    // nn::Result RequestChangeStateForceAsync(std::int32_t targetState) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestChangeStateForceAsync, (::std::int32_t targetState))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestChangeStateForceAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(targetState)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestChangeStateForceAsync)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::npns::INpnsSystem>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_WITH_BASE((::nn::npns::INpnsSystem), (::nn::npns::INpnsUser))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListenUndelivered)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListenUndelivered)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SubscribeTopic)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(name)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SubscribeTopic)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(name)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnsubscribeTopic)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(name)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnsubscribeTopic)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(name)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(QueryIsTopicExist)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(name)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(QueryIsTopicExist)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(bResult),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(name)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateTokenWithApplicationId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateTokenWithApplicationId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outToken),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(applicationId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DestroyTokenWithApplicationId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DestroyTokenWithApplicationId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(applicationId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UploadTokenToBaaS)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UploadTokenToBaaS)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DestroyTokenForBaaS)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DestroyTokenForBaaS)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetPlayReportRequestEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetPlayReportRequestEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateJid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateJid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DestroyJid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DestroyJid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AttachJid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(jid)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(password)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AttachJid)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(jid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(password)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DetachJid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(jid)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(password)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DetachJid)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(jid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(password)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestChangeStateForceTimed)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestChangeStateForceTimed)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(targetState),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(timeout)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestChangeStateForceAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestChangeStateForceAsync)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(targetState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListenUndelivered)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SubscribeTopic)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnsubscribeTopic)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(QueryIsTopicExist)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateTokenWithApplicationId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DestroyTokenWithApplicationId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UploadTokenToBaaS)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DestroyTokenForBaaS)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetPlayReportRequestEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateJid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DestroyJid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AttachJid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DetachJid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestChangeStateForceTimed)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestChangeStateForceAsync)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END_WITH_BASE

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::npns::INpnsSystem))
