﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os/os_Thread.h>
#include <nn/util/util_BitArray.h>
#include <nn/nim/srv/nim_OsUtil.h>

namespace nn { namespace nim { namespace srv {
    struct ThreadInfo
    {
        os::ThreadType* thread;
        int priority;
        char* stack;
        size_t stackSize;
        const char* threadName;
    };

    class ThreadAllocator
    {
    public:
        ThreadAllocator(os::ThreadType threadList[], int count, int priority, char* stackHeap, size_t stackHeapSize, size_t stackSize, const char* threadName) NN_NOEXCEPT;

        Result Allocate(ThreadInfo* outValue) NN_NOEXCEPT;

        void Free(const ThreadInfo& info) NN_NOEXCEPT;

    private:
        os::ThreadType* m_ThreadList;
        const int m_ThreadPriority;
        char* m_StackHeap;
        const size_t m_StackHeapSize;
        const size_t m_StackSize;
        const char* m_ThreadName;
        NonRecursiveMutex m_Mutex;
        Bit64 m_Bitmap;
        util::BitArray m_BitArray;
    };
}}}
