﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_TimeSpan.h>
#include <nn/nim/detail/nim_IAsync.sfdl.h>
#include <nn/nim/detail/nim_IShopServiceManager.sfdl.h>
#include <nn/nim/srv/nim_DeviceAccountStore.h>
#include <nn/nim/srv/nim_DeviceAuthenticationTokenInfoCache.h>
#include <nn/nim/srv/nim_DeviceContext.h>
#include <nn/nim/srv/nim_EciAccessor.h>
#include <nn/nim/srv/nim_VirtualAccountStore.h>

namespace nn { namespace nim { namespace srv {
    class ShopServiceManager
    {
    public:
        Result Initialize(DeviceContext* deviceContext, DeviceAccountStore* deviceAccountStore, VirtualAccountStore* virtualAccountStore) NN_NOEXCEPT;

        // ec_DeviceAuthenticationApi.h
        Result RequestDeviceAuthenticationToken(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncValue>> outAsync) NN_NOEXCEPT;
        Result RequestCachedDeviceAuthenticationToken(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncValue>> outAsync, nn::TimeSpan remainingTime) NN_NOEXCEPT;

        // ec_DeviceAccountApi.h
        Result RequestRegisterDeviceAccount(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncResult>> outAsync) NN_NOEXCEPT;
        Result RequestUnregisterDeviceAccount(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncResult>> outAsync) NN_NOEXCEPT;
        Result RequestDeviceAccountStatus(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncValue>> outAsync) NN_NOEXCEPT;
        Result RequestDeviceRegistrationInfo(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncValue>> outAsync) NN_NOEXCEPT;
        Result GetDeviceAccountInfo(sf::Out<ec::system::DeviceAccountInfo> outValue) NN_NOEXCEPT;
        Result RequestTransferDeviceAccount(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncResult>> outAsync) NN_NOEXCEPT;
        Result RequestSyncRegistration(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncResult>> outAsync) NN_NOEXCEPT;
        Result IsOwnDeviceId(sf::Out<bool> outValue, uint64_t deviceId) NN_NOEXCEPT;

        // ec_NotificationApi.h
        Result RequestRegisterNotificationToken(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncResult>> outAsync, const npns::NotificationToken& notificationToken) NN_NOEXCEPT;

        // ec_DeviceLinkApi.h
        Result RequestUnlinkDevice(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncResult>> outAsync, const account::NintendoAccountId naUserId) NN_NOEXCEPT;
        Result RequestUnlinkDeviceIntegrated(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncResult>> outAsync, const account::Uid uid) NN_NOEXCEPT;
        Result RequestUnlinkDeviceAll(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncResult>> outAsync) NN_NOEXCEPT;
        Result RequestLinkDevice(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncResult>> outAsync, const account::Uid uid) NN_NOEXCEPT;
        Result HasDeviceLink(sf::Out<bool> outValue, const account::Uid& uid) NN_NOEXCEPT;
        Result RequestCreateVirtualAccount(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncResult>> outAsync, const account::Uid uid) NN_NOEXCEPT;
        Result RequestDeviceLinkStatus(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncValue>> outAsync, const account::Uid& uid) NN_NOEXCEPT;

        // ec_VirtualAccount[System]Api.h
        Result GetAccountByVirtualAccount(sf::Out<account::Uid> outValue, ec::system::VirtualAccountId vaId) NN_NOEXCEPT
        {
            return m_VirtualAccountStore->GetAccount(outValue.GetPointer(), vaId);
        }

        // ec_Ticket[System]Api.h
        Result RequestDownloadTicket(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncResult>> outAsync, const es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT;
        Result RequestDownloadTicketForPrepurchasedContents(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncValue>> outAsync, const nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT;
        Result RequestSyncTicket(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncProgressResult>> outAsync) NN_NOEXCEPT;

    private:
        DeviceContext* m_DeviceContext;
        DeviceAccountStore* m_DeviceAccountStore;
        VirtualAccountStore* m_VirtualAccountStore;
        DeviceAuthenticationTokenInfoCache m_CashedTokenInfo;
    };
}}}
