﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/util/util_Optional.h>
#include <nn/ncm/ncm_ContentMetaKey.h>
#include <nn/ncm/ncm_ContentMetaExtendedData.h>
#include <nn/ncm/ncm_StorageId.h>
#include <nn/fs/fs_File.h>
#include <nn/ovln/ovln_SenderForOverlay.h>
#include <nn/nim/srv/nim_DeviceAccountStore.h>
#include <nn/nim/srv/nim_FileNetworkInstallTaskMeta.h>
#include <nn/nim/srv/nim_NetworkInstallTaskBase.h>
#include <nn/nim/nim_NetworkInstallTaskId.h>
#include <nn/nim/nim_NetworkInstallTaskInfo.h>

namespace nn { namespace nim { namespace srv {

    // 最大何個のパッチ間差分での更新を許容するか
    // これを超えた場合、直接ダウンロードになる
    const int MaxUpdateStep = 64;

    class RouteFinder;
    class NetworkInstallTask : public NetworkInstallTaskBase
    {
    public:
        Result Initialize(DeviceContext* deviceContext, DeviceAccountStore* deviceAccountStore, const char* metaFilePath, const char* dataFilePath, ovln::SenderForOverlayType* sender) NN_NOEXCEPT;
        Result Add(const ncm::ContentMetaKey keyList[], int count) NN_NOEXCEPT;
        ncm::ApplicationId GetApplicationId() const NN_NOEXCEPT
        {
            return m_Meta.GetApplicationId();
        }
        Result SetAttribute(Bit64 attribute) NN_NOEXCEPT
        {
            return m_Meta.SetAttribute(attribute);
        }
        Bit64 GetAttribute() const NN_NOEXCEPT
        {
            return m_Meta.GetAttribute();
        }
        virtual ncm::InstallProgress GetProgress() NN_NOEXCEPT NN_OVERRIDE;
        Result ListContentMetaKeyFromInstallMeta(int* outCount, ncm::ContentMetaKey* outList, int numList, int offset) NN_NOEXCEPT;

    private:
        virtual int CountInstallContentMetaKey() NN_NOEXCEPT NN_OVERRIDE;
        virtual Result GetInstallContentMetaKey(ncm::ContentMetaKey* outValue, int index) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result OnExecuteComplete() NN_NOEXCEPT NN_OVERRIDE;

        Result ResolvePatchUpdateRoute(const ncm::ContentMetaKey& key, const ncm::PackagedContentMetaReader& reader) NN_NOEXCEPT;
        virtual Result PrepareDependency() NN_NOEXCEPT NN_OVERRIDE;
        Result PrepareAocDependency() NN_NOEXCEPT;
        Result PreparePatchDependency(const ncm::ContentMetaKey& key) NN_NOEXCEPT;

        Result RegisterRoute(const ncm::PatchMetaExtendedDataReader& reader, const ncm::ContentMetaKey& key, const RouteFinder* routeFinder) NN_NOEXCEPT;
        Result RollbackRoute(const ncm::PatchMetaExtendedDataReader& reader, const RouteFinder* routeFinder, int index) NN_NOEXCEPT;

        // システム的にアプリに紐づけることができる追加コンテンツの最大数
        static const int MaxAddOnContentPerApplication = 2048;

        // 運用で扱うアプリあたりの追加コンテンツ最大数
        static const int MaxOperationalAddOnContentCount = 2000;

        // 運用で発生しうるアプリケーション1つに対するコンテンツの数。
        // アプリ(1) + パッチ(1) + 追加コンテンツ(2000)
        static const int MaxOperationalContentCountPerApplication = MaxOperationalAddOnContentCount + 2;

        Result HasAocInstallContentMeta(bool* out) NN_NOEXCEPT;
        bool IsAnyAocInstalled() NN_NOEXCEPT;
        Result UpdateAocInstallContentMetaData(ncm::ContentMetaKey outPrepared[], int *outCount, const ncm::ContentMetaKey latestKeyList[], int latestKeyCount, int maxAddOnContent) NN_NOEXCEPT;
        Result AddAocInstallContentMetaDataNewerThanInstalled(const ncm::ContentMetaKey preparedKey[], int preparedKeyCount, const ncm::ContentMetaKey latestKeyList[], int latestKeyCount, ncm::ApplicationId ownerId) NN_NOEXCEPT;
        Result AddInstallContentMeta(const ncm::ContentMetaKey& key) NN_NOEXCEPT;
        Result ListLatestInstalledContentMetaKey(ncm::ContentMetaKey out[], int* outCount, int maxOutCount, const ncm::ContentMetaKey excludeList[], int excludeListCount, ncm::ApplicationId& ownerId) NN_NOEXCEPT;
        virtual Result InstallTicket(const nn::fs::RightsId& rightsId, nn::ncm::ContentMetaType contentMetaType) NN_NOEXCEPT NN_OVERRIDE;

        ovln::SenderForOverlayType* m_Sender;
        FileNetworkInstallTaskMeta m_Meta;
        ncm::FileInstallTaskData m_Data;
        DeviceAccountStore* m_DeviceAccountStore;
    };
}}}
