﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/nifm_Common.h>

#include <nn/nifm/nifm_TypesRequirement.h>
#include <nn/nifm/nifm_TypesClientManagement.h>
#include <nn/nifm/nifm_TypesIpSetting.h>
#include <nn/nifm/nifm_NetworkConnection.h>

#include <nn/nifm/detail/nifm_RequestClient.h>

namespace nn
{
namespace nifm
{
    //! @name テスト用 API
    //! @{

    nn::Result FinalizeForTest() NN_NOEXCEPT;

    nn::Result FinalizeSystemForTest() NN_NOEXCEPT;

    nn::Result FinalizeAdminForTest() NN_NOEXCEPT;

    /**
     * @brief   スリープ準備状態に遷移させます。
     *
     * @retresult
     *   @handleresult{
     *     nn::ResultSuccess, 処理に成功しました。
     *   }
     * @endretresult
     *
     * @pre
     *   - ライブラリが初期化済み
     *
     * @details
     *  この関数はテスト用です。@n
     *
     *  スリープ準備状態に遷移すると、受理済みの利用要求はスリープ中も維持する設定になっていなければ却下され、審査中の理由はスリープ準備状態終了まで保留されます。@n
     *
     *  この関数はすぐに返りますが、スリープ準備完了状態に遷移するまでは時間がかかることがあります。
     */
    nn::Result PutToSleep() NN_NOEXCEPT;

    /**
     * @brief   ウェイク状態に遷移させます。
     *
     * @retresult
     *   @handleresult{
     *     nn::ResultSuccess, 処理に成功しました。
     *   }
     * @endretresult
     *
     * @pre
     *   - ライブラリが初期化済み
     *
     * @details
     *  この関数はテスト用です。
     */
    nn::Result WakeUp() NN_NOEXCEPT;

    /**
     * @brief   シャットダウン状態に遷移させます。
     *
     * @retresult
     *   @handleresult{
     *     nn::ResultSuccess, 処理に成功しました。
     *   }
     * @endretresult
     *
     * @pre
     *   - ライブラリが初期化済み
     *
     * @details
     *  この関数はテスト用です。
     */
    nn::Result Shutdown() NN_NOEXCEPT;

    /**
     * @brief   独占的に利用要求を受け入れるクライアントを指定します。
     *
     * @retresult
     *   @handleresult{
     *     nn::ResultSuccess, 処理に成功しました。
     *   }
     * @endretresult
     *
     * @pre
     *   - ライブラリが初期化済み
     *
     * @details
     *  この関数はテスト用です。@n
     *
     *  無効な ID を指定した場合、独占は解除されます。@n
     */
    nn::Result SetExclusiveClient(ClientId clientId) NN_NOEXCEPT;

    /**
     * @brief   利用要求のハンドルから RequestClient へのポインタを取得します。
     *
     * @return  RequestClient のポインタが返ります。
     *
     * @pre
     *   - ライブラリが初期化済み
     *
     * @details
     */
    detail::RequestClient* GetRequestClientPointer(RequestHandle handle) NN_NOEXCEPT;

    /**
     * @brief   グローバルな nn::nifm::NetworkConnection へのポインタを取得します。
     *
     * @return  NetworkConnection へのポインタが返ります。
     *
     * @pre
     *     - ライブラリが初期化済み
     *
     */
    NetworkConnection* GetGlobalNetworkConnectionPointer() NN_NOEXCEPT;

    /**
     * @brief SSID リスト由来の接続設定などが使用するデフォルトの IP 設定を取得します。
     *
     * @retresult
     *   @handleresult{
     *     nn::ResultSuccess, 処理に成功しました。
     *   }
     * @endretresult
     *
     * @pre
     *   - ライブラリが初期化済み
     *
     */
    nn::Result GetDefaultIpSetting(IpSettingData* pOutipSetting) NN_NOEXCEPT;

    /**
     * @brief SSID リスト由来の接続設定などが使用するデフォルトの IP 設定を設定します。
     *
     * @retresult
     *   @handleresult{
     *     nn::ResultSuccess, 処理に成功しました。
     *   }
     * @endretresult
     *
     * @pre
     *   - ライブラリが初期化済み
     *
     */
    nn::Result SetDefaultIpSetting(const IpSettingData& ipSetting) NN_NOEXCEPT;

    //! @}
}
}
