﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/nifm_TypesNetworkProfile.h>

namespace nn
{
namespace nifm
{
namespace detail
{

char* Strtokc(char *pBuffer, char delimiter) NN_NOEXCEPT;

class SsidListAccessor
{
private:
    static const char RomMountName[];
    static const char FilePath[];
    // (37+44+85+1+1+85+1)*300=76200[byte] が最大サイズ（空白なし）
    static const int MaxSsidListSize = 76200;

private:
    char* m_pCacheBuffer;
    char* m_pFileBuffer;
    char* m_pCurrentPos;

public:
    SsidListAccessor() NN_NOEXCEPT;
    ~SsidListAccessor() NN_NOEXCEPT;

    // SSID リスト読み込み
    Result Load() NN_NOEXCEPT;
    Result Load(const char* pInString) NN_NOEXCEPT;

    // SSID リストバージョンの取得
    Result GetVersion(char* pOutVersion) const NN_NOEXCEPT;

    // SSID リストエントリの読み込み
    Result GetNextEntry(
        nn::util::Uuid *pOutUuid, Ssid* pOutSsid, SharedKey* pOutPassphrase,
        Authentication *pOutAuthentication, Encryption *pOutEncryption, char* pOutName, bool *pOutIsAutoConnect) NN_NOEXCEPT;
};

}
}
}
