﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/detail/nifm_CommonDetail.h>
#include <nn/nifm/detail/service/nifm_StaticServiceInterface.h>

#include <nn/nifm/detail/util/nifm_Heap.h>


namespace nn
{
namespace nifm
{
namespace detail
{

    const Capability g_Capability = {
        true,  // isArbitraryPrioritySettable
        true,  // isArbitraryPresetSettable
        true,  // isRequirementSettable
        true,  // isRejectableFlagSettable
        true,  // isSustainableFlagSettable
        true,  // isProfileEditable
        true,  // isPassphraseAcquirable
        true,  // isSsidListAcquirable
    };

class HipcServerManager
{
private:
    SfExpHeapAllocator<4 * 1024> m_SfExpHeapAllocator;

    // DFC モデルでは権限を区別せず、サービスオブジェクトを共有する
    nn::sf::UnmanagedServiceObject<IStaticService, StaticServiceInterface> m_StaticService;

public:
    explicit HipcServerManager(ServiceProvider* pServiceProvider) NN_NOEXCEPT
        : m_SfExpHeapAllocator(nn::lmem::CreationOption_NoOption),
          m_StaticService(pServiceProvider, g_Capability, m_SfExpHeapAllocator.GetBase())
    {
    }

    ~HipcServerManager() NN_NOEXCEPT
    {
    }

    void GetAdminServiceSharedPointer(nn::sf::SharedPointer<detail::IGeneralService>* ppGeneralService) NN_NOEXCEPT
    {
        auto result = m_StaticService.CreateGeneralService(ppGeneralService, 0);
        if (result.IsFailure())
        {
            *ppGeneralService = nullptr;
        }
    }

    void GetSystemServiceSharedPointer(nn::sf::SharedPointer<detail::IGeneralService>* ppGeneralService) NN_NOEXCEPT
    {
        auto result = m_StaticService.CreateGeneralService(ppGeneralService, 0);
        if (result.IsFailure())
        {
            *ppGeneralService = nullptr;
        }
    }

    void GetUserServiceSharedPointer(nn::sf::SharedPointer<detail::IGeneralService>* ppGeneralService) NN_NOEXCEPT
    {
        auto result = m_StaticService.CreateGeneralService(ppGeneralService, 0);
        if (result.IsFailure())
        {
            *ppGeneralService = nullptr;
        }
    }
};

}
}
}
