﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/detail/nifm_CommonDetail.h>

#include <nn/nifm/detail/core/profile/nifm_NetworkProfileBase.h>
#include <nn/nifm/detail/core/profile/nifm_WirelessUserSetting.h>
#include <nn/nifm/detail/core/profile/nifm_IpSetting.h>


namespace nn
{
namespace nifm
{
namespace detail
{

class UserNetworkProfile : public NetworkProfileBase
{
private:
    NetworkInterfaceType m_NetworkInterfaceType;
    WirelessUserSetting m_WirelessSetting;
    IpSetting m_IpSetting;

public:
    UserNetworkProfile() {}
    virtual ~UserNetworkProfile() {}

    explicit UserNetworkProfile( const nn::util::Uuid& id, const char* pName, bool autoConnect, bool largeCapacity, const WirelessUserSetting& wirelessSetting, const IpSetting& ipSetting ) NN_NOEXCEPT
        : NetworkProfileBase( id, pName, autoConnect, largeCapacity ),
          m_WirelessSetting(wirelessSetting),
          m_IpSetting( ipSetting )
    {
    }

    virtual NetworkInterfaceType GetNetworkInterfaceType() const NN_NOEXCEPT NN_OVERRIDE
    {
        return m_NetworkInterfaceType;
    }

    virtual void SetNetworkInterfaceType(NetworkInterfaceType networkInterfaceType) NN_NOEXCEPT NN_OVERRIDE
    {
        m_NetworkInterfaceType = networkInterfaceType;
    }

    const WirelessUserSetting& GetWirelessUserSetting() const NN_NOEXCEPT
    {
        return m_WirelessSetting;
    }

    virtual const WirelessUserSetting& GetWirelessSetting() const NN_NOEXCEPT NN_OVERRIDE
    {
        return m_WirelessSetting;
    }

    virtual WirelessUserSetting* GetWirelessSettingPointer() NN_NOEXCEPT NN_OVERRIDE
    {
        return &m_WirelessSetting;
    }

    virtual const WirelessUserSetting* GetWirelessSettingPointer() const NN_NOEXCEPT NN_OVERRIDE
    {
        return &m_WirelessSetting;
    }

    virtual const IpSetting& GetIpSetting() const NN_NOEXCEPT NN_OVERRIDE
    {
        return m_IpSetting;
    }

    virtual IpSetting* GetIpSettingPointer() NN_NOEXCEPT NN_OVERRIDE
    {
        return &m_IpSetting;
    }

    virtual const IpSetting* GetIpSettingPointer() const NN_NOEXCEPT NN_OVERRIDE
    {
        return &m_IpSetting;
    }

    virtual ProfileType GetType() const NN_NOEXCEPT NN_OVERRIDE
    {
        return ProfileType::UserProfile;
    }
};

}
}
}
