﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/detail/nifm_CommonDetail.h>

#include <nn/nifm/detail/core/connectionConfirmation/nifm_HttpClientBase.win32.h>
#include <nn/nifm/nifm_TypesNetworkInterface.h>
#include <nn/nifm/nifm_TypesWirelessSetting.h>


namespace nn
{
namespace nifm
{
namespace detail
{

class AuthenticationClient : public HttpClientBase
{
    NN_DISALLOW_COPY(AuthenticationClient);
    NN_DISALLOW_MOVE(AuthenticationClient);

public:
    static const char AuthenticationUrl[];

public:
    explicit AuthenticationClient(const HttpResponse* pResponse) NN_NOEXCEPT;
    ~AuthenticationClient() NN_NOEXCEPT;

    nn::Result Authenticate(const char* pUrl) NN_NOEXCEPT;

    // リクエストパラメータ
    void SetMacAddress(const MacAddress& macAddress) NN_NOEXCEPT;
    void SetBssid(const MacAddress& bssid) NN_NOEXCEPT;
    void SetSsid(const Ssid& ssid) NN_NOEXCEPT;

    const char* GetRedirectUrlPointer() NN_NOEXCEPT;
};
}
}
}
