﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// ログの有効化
//#define NN_DETAIL_NIFM_LOG_ENABLED               1 // NOLINT(preprocessor/const)

// 上記ログの有効化時、さらに詳細情報が欲しい場合の個別定義
//#define NN_DETAIL_NIFM_LOG_SECURITY_INFO_ENABLED 1 // NOLINT(preprocessor/const)
//#define NN_DETAIL_NIFM_LOG_AP_ENABLED            1 // NOLINT(preprocessor/const)
//#define NN_DETAIL_NIFM_LOG_SSIDLIST_ENABLED      1 // NOLINT(preprocessor/const)

// ログ出力先の変更
//#define NN_DETAIL_NIFM_LOG_UART                  1 // NOLINT(preprocessor/const)

/*** Trace:0 ***/
// Verbosity(0) :
// Verbosity(1) :
// Verbosity(2) : 接続試行時の AP・接続設定情報の詳細
// Verbosity(3) :

/*** Info:1 ***/
// Verbosity(0) : 利用要求状態の変化
// Verbosity(1) : 利用要求・統合利用要求の詳細
// Verbosity(2) :
// Verbosity(3) :

/*** Warn:2 ***/
// Verbosity(0) :
// Verbosity(1) :
// Verbosity(2) :
// Verbosity(3) :

/*** Error:3 ***/
// Verbosity(0) :
// Verbosity(1) :
// Verbosity(2) :
// Verbosity(3) :

/*** Fatal:4 ***/
// Verbosity(0) :
// Verbosity(1) :
// Verbosity(2) :
// Verbosity(3) :


#define NN_DETAIL_NIFM_CONFIG_SERVER_MODEL_PROCESS  0
#define NN_DETAIL_NIFM_CONFIG_SERVER_MODEL_THREAD   1

#if defined(NN_BUILD_CONFIG_OS_WIN)
#define NN_DETAIL_NIFM_CONFIG_SERVER_MODEL NN_DETAIL_NIFM_CONFIG_SERVER_MODEL_THREAD
#else
#define NN_DETAIL_NIFM_CONFIG_SERVER_MODEL NN_DETAIL_NIFM_CONFIG_SERVER_MODEL_PROCESS
#endif

#define NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL_DFC   0
#define NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL_HIPC  1 // TODO:DFC は未サポート

#if defined(NN_BUILD_CONFIG_OS_WIN)
#define NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL_DEFAULT   NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL_DFC
#elif defined(NN_BUILD_CONFIG_OS_HORIZON)
#define NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL_DEFAULT   NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL_HIPC
#else
#define NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL_DEFAULT   NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL_DFC
#endif

#define NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL   NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL_DEFAULT

#if defined(NN_BUILD_CONFIG_OS_WIN)
#include "nifm_ConfigDetail.win32.h"
#elif defined(NN_BUILD_CONFIG_OS_HORIZON)
#include "nifm_ConfigDetail.horizon.h"
#endif
