﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      nfp モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_NFP_TRACE(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(nfp, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_NFP_TRACE_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(nfp, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_NFP_TRACE_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(nfp, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_NFP_TRACE_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(nfp, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_NFP_INFO(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(nfp, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_NFP_INFO_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(nfp, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_NFP_INFO_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(nfp, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_NFP_INFO_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(nfp, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_NFP_WARN(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(nfp, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_NFP_WARN_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(nfp, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_NFP_WARN_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(nfp, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_NFP_WARN_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(nfp, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_NFP_ERROR(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(nfp, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_NFP_ERROR_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(nfp, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_NFP_ERROR_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(nfp, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_NFP_ERROR_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(nfp, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_NFP_FATAL(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(nfp, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_NFP_FATAL_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(nfp, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_NFP_FATAL_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(nfp, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_NFP_FATAL_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(nfp, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_NFP_VTRACE(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(nfp, Trace, 0, format, args)
#define NN_DETAIL_NFP_VTRACE_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(nfp, Trace, 1, format, args)
#define NN_DETAIL_NFP_VTRACE_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(nfp, Trace, 2, format, args)
#define NN_DETAIL_NFP_VTRACE_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(nfp, Trace, 3, format, args)

#define NN_DETAIL_NFP_VINFO(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(nfp, Info, 0, format, args)
#define NN_DETAIL_NFP_VINFO_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(nfp, Info, 1, format, args)
#define NN_DETAIL_NFP_VINFO_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(nfp, Info, 2, format, args)
#define NN_DETAIL_NFP_VINFO_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(nfp, Info, 3, format, args)

#define NN_DETAIL_NFP_VWARN(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(nfp, Warn, 0, format, args)
#define NN_DETAIL_NFP_VWARN_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(nfp, Warn, 1, format, args)
#define NN_DETAIL_NFP_VWARN_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(nfp, Warn, 2, format, args)
#define NN_DETAIL_NFP_VWARN_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(nfp, Warn, 3, format, args)

#define NN_DETAIL_NFP_VERROR(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(nfp, Error, 0, format, args)
#define NN_DETAIL_NFP_VERROR_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(nfp, Error, 1, format, args)
#define NN_DETAIL_NFP_VERROR_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(nfp, Error, 2, format, args)
#define NN_DETAIL_NFP_VERROR_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(nfp, Error, 3, format, args)

#define NN_DETAIL_NFP_VFATAL(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(nfp, Fatal, 0, format, args)
#define NN_DETAIL_NFP_VFATAL_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(nfp, Fatal, 1, format, args)
#define NN_DETAIL_NFP_VFATAL_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(nfp, Fatal, 2, format, args)
#define NN_DETAIL_NFP_VFATAL_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(nfp, Fatal, 3, format, args)

#define NN_DETAIL_NFP_PUT_TRACE(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(nfp, Trace, 0, text, length)
#define NN_DETAIL_NFP_PUT_TRACE_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(nfp, Trace, 1, text, length)
#define NN_DETAIL_NFP_PUT_TRACE_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(nfp, Trace, 2, text, length)
#define NN_DETAIL_NFP_PUT_TRACE_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(nfp, Trace, 3, text, length)

#define NN_DETAIL_NFP_PUT_INFO(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(nfp, Info, 0, text, length)
#define NN_DETAIL_NFP_PUT_INFO_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(nfp, Info, 1, text, length)
#define NN_DETAIL_NFP_PUT_INFO_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(nfp, Info, 2, text, length)
#define NN_DETAIL_NFP_PUT_INFO_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(nfp, Info, 3, text, length)

#define NN_DETAIL_NFP_PUT_WARN(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(nfp, Warn, 0, text, length)
#define NN_DETAIL_NFP_PUT_WARN_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(nfp, Warn, 1, text, length)
#define NN_DETAIL_NFP_PUT_WARN_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(nfp, Warn, 2, text, length)
#define NN_DETAIL_NFP_PUT_WARN_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(nfp, Warn, 3, text, length)

#define NN_DETAIL_NFP_PUT_ERROR(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(nfp, Error, 0, text, length)
#define NN_DETAIL_NFP_PUT_ERROR_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(nfp, Error, 1, text, length)
#define NN_DETAIL_NFP_PUT_ERROR_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(nfp, Error, 2, text, length)
#define NN_DETAIL_NFP_PUT_ERROR_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(nfp, Error, 3, text, length)

#define NN_DETAIL_NFP_PUT_FATAL(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(nfp, Fatal, 0, text, length)
#define NN_DETAIL_NFP_PUT_FATAL_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(nfp, Fatal, 1, text, length)
#define NN_DETAIL_NFP_PUT_FATAL_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(nfp, Fatal, 2, text, length)
#define NN_DETAIL_NFP_PUT_FATAL_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(nfp, Fatal, 3, text, length)
