﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/applet/applet_FundamentalTypes.h>
#include <nn/hid/hid_NpadCommonTypes.h>
#include <nn/nfc/nfc_Types.h>
#include <nn/nfp/nfp_PrivateTypes.h>
#include <nn/nfp/nfp_Types.h>
#include <nn/nn_BitTypes.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/xcd/xcd_NfcTypes.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace nfp { namespace detail { // NOLINT(whitespace/braces)

class ISystem;

class ISystemManager;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(ISystem, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(ISystem)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(InitializeNfp, (::nn::applet::AppletResourceUserId aruid, ::nn::Bit64 pid, const ::nn::sf::InArray<::nn::xcd::McuVersionDataForNfc>& mcuVersionData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(FinalizeNfp)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListDevicesNfp, (const ::nn::sf::OutArray<::nn::nfc::DeviceHandle>& devices, ::nn::sf::Out<::std::int32_t> count))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StartDetectionNfp, (::nn::nfc::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StopDetectionNfp, (::nn::nfc::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(MountNfp, (::nn::nfc::DeviceHandle deviceHandle, ::nn::Bit32 modelType, ::nn::Bit32 mountTarget))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UnmountNfp, (::nn::nfc::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(FlushNfp, (::nn::nfc::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RestoreNfp, (::nn::nfc::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetTagInfoNfp, (::nn::sf::Out<::nn::nfc::TagInfo> tagInfo, ::nn::nfc::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetRegisterInfoNfp, (::nn::sf::Out<::nn::nfp::RegisterInfo> registerInfo, ::nn::nfc::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetCommonInfoNfp, (::nn::sf::Out<::nn::nfp::CommonInfo> commonInfo, ::nn::nfc::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetModelInfoNfp, (::nn::sf::Out<::nn::nfp::ModelInfo> modelInfo, ::nn::nfc::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetActivateEventHandleNfp, (::nn::sf::Out<::nn::sf::NativeHandle> handle, ::nn::nfc::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDeactivateEventHandleNfp, (::nn::sf::Out<::nn::sf::NativeHandle> handle, ::nn::nfc::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetStateNfp, (::nn::sf::Out<::nn::Bit32> state))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDeviceStateNfp, (::nn::sf::Out<::nn::Bit32> state, ::nn::nfc::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetNpadIdNfp, (::nn::sf::Out<::nn::hid::NpadIdType> npadId, ::nn::nfc::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAvailabilityChangeEventHandleNfp, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(FormatNfp, (::nn::nfc::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAdminInfoNfp, (::nn::sf::Out<::nn::nfp::AdminInfo> adminInfo, ::nn::nfc::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetRegisterInfoPrivateNfp, (::nn::sf::Out<::nn::nfp::RegisterInfoPrivate> registerInfo, ::nn::nfc::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetRegisterInfoPrivateNfp, (::nn::nfc::DeviceHandle deviceHandle, const ::nn::nfp::RegisterInfoPrivate& registerInfo))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteRegisterInfoNfp, (::nn::nfc::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteApplicationAreaNfp, (::nn::nfc::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ExistsApplicationAreaNfp, (::nn::sf::Out<bool> flag, ::nn::nfc::DeviceHandle deviceHandle))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(ISystem)

        ::nn::Result InitializeNfp(::nn::applet::AppletResourceUserId aruid, ::nn::Bit64 pid, const ::nn::sf::InArray<::nn::xcd::McuVersionDataForNfc>& mcuVersionData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(InitializeNfp, (aruid, pid, mcuVersionData));
        }

        ::nn::Result FinalizeNfp() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(FinalizeNfp);
        }

        ::nn::Result ListDevicesNfp(const ::nn::sf::OutArray<::nn::nfc::DeviceHandle>& devices, ::nn::sf::Out<::std::int32_t> count) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListDevicesNfp, (devices, count));
        }

        ::nn::Result StartDetectionNfp(::nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StartDetectionNfp, (deviceHandle));
        }

        ::nn::Result StopDetectionNfp(::nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StopDetectionNfp, (deviceHandle));
        }

        ::nn::Result MountNfp(::nn::nfc::DeviceHandle deviceHandle, ::nn::Bit32 modelType, ::nn::Bit32 mountTarget) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(MountNfp, (deviceHandle, modelType, mountTarget));
        }

        ::nn::Result UnmountNfp(::nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UnmountNfp, (deviceHandle));
        }

        ::nn::Result FlushNfp(::nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(FlushNfp, (deviceHandle));
        }

        ::nn::Result RestoreNfp(::nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RestoreNfp, (deviceHandle));
        }

        ::nn::Result GetTagInfoNfp(::nn::sf::Out<::nn::nfc::TagInfo> tagInfo, ::nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetTagInfoNfp, (tagInfo, deviceHandle));
        }

        ::nn::Result GetRegisterInfoNfp(::nn::sf::Out<::nn::nfp::RegisterInfo> registerInfo, ::nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetRegisterInfoNfp, (registerInfo, deviceHandle));
        }

        ::nn::Result GetCommonInfoNfp(::nn::sf::Out<::nn::nfp::CommonInfo> commonInfo, ::nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetCommonInfoNfp, (commonInfo, deviceHandle));
        }

        ::nn::Result GetModelInfoNfp(::nn::sf::Out<::nn::nfp::ModelInfo> modelInfo, ::nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetModelInfoNfp, (modelInfo, deviceHandle));
        }

        ::nn::Result GetActivateEventHandleNfp(::nn::sf::Out<::nn::sf::NativeHandle> handle, ::nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetActivateEventHandleNfp, (handle, deviceHandle));
        }

        ::nn::Result GetDeactivateEventHandleNfp(::nn::sf::Out<::nn::sf::NativeHandle> handle, ::nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDeactivateEventHandleNfp, (handle, deviceHandle));
        }

        ::nn::Result GetStateNfp(::nn::sf::Out<::nn::Bit32> state) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetStateNfp, (state));
        }

        ::nn::Result GetDeviceStateNfp(::nn::sf::Out<::nn::Bit32> state, ::nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDeviceStateNfp, (state, deviceHandle));
        }

        ::nn::Result GetNpadIdNfp(::nn::sf::Out<::nn::hid::NpadIdType> npadId, ::nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetNpadIdNfp, (npadId, deviceHandle));
        }

        ::nn::Result GetAvailabilityChangeEventHandleNfp(::nn::sf::Out<::nn::sf::NativeHandle> handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAvailabilityChangeEventHandleNfp, (handle));
        }

        ::nn::Result FormatNfp(::nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(FormatNfp, (deviceHandle));
        }

        ::nn::Result GetAdminInfoNfp(::nn::sf::Out<::nn::nfp::AdminInfo> adminInfo, ::nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAdminInfoNfp, (adminInfo, deviceHandle));
        }

        ::nn::Result GetRegisterInfoPrivateNfp(::nn::sf::Out<::nn::nfp::RegisterInfoPrivate> registerInfo, ::nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetRegisterInfoPrivateNfp, (registerInfo, deviceHandle));
        }

        ::nn::Result SetRegisterInfoPrivateNfp(::nn::nfc::DeviceHandle deviceHandle, const ::nn::nfp::RegisterInfoPrivate& registerInfo) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetRegisterInfoPrivateNfp, (deviceHandle, registerInfo));
        }

        ::nn::Result DeleteRegisterInfoNfp(::nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteRegisterInfoNfp, (deviceHandle));
        }

        ::nn::Result DeleteApplicationAreaNfp(::nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteApplicationAreaNfp, (deviceHandle));
        }

        ::nn::Result ExistsApplicationAreaNfp(::nn::sf::Out<bool> flag, ::nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ExistsApplicationAreaNfp, (flag, deviceHandle));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class ISystem
    {
    public:
        nn::Result InitializeNfp(nn::applet::AppletResourceUserId aruid, nn::Bit64 pid, const nn::sf::InArray<nn::xcd::McuVersionDataForNfc>& mcuVersionData) NN_NOEXCEPT;
        nn::Result FinalizeNfp() NN_NOEXCEPT;
        nn::Result ListDevicesNfp(const nn::sf::OutArray<nn::nfc::DeviceHandle>& devices, nn::sf::Out<std::int32_t> count) NN_NOEXCEPT;
        nn::Result StartDetectionNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result StopDetectionNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result MountNfp(nn::nfc::DeviceHandle deviceHandle, nn::Bit32 modelType, nn::Bit32 mountTarget) NN_NOEXCEPT;
        nn::Result UnmountNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result FlushNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result RestoreNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result GetTagInfoNfp(nn::sf::Out<nn::nfc::TagInfo> tagInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result GetRegisterInfoNfp(nn::sf::Out<nn::nfp::RegisterInfo> registerInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result GetCommonInfoNfp(nn::sf::Out<nn::nfp::CommonInfo> commonInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result GetModelInfoNfp(nn::sf::Out<nn::nfp::ModelInfo> modelInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result GetActivateEventHandleNfp(nn::sf::Out<nn::sf::NativeHandle> handle, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result GetDeactivateEventHandleNfp(nn::sf::Out<nn::sf::NativeHandle> handle, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result GetStateNfp(nn::sf::Out<nn::Bit32> state) NN_NOEXCEPT;
        nn::Result GetDeviceStateNfp(nn::sf::Out<nn::Bit32> state, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result GetNpadIdNfp(nn::sf::Out<nn::hid::NpadIdType> npadId, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result GetAvailabilityChangeEventHandleNfp(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
        nn::Result FormatNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result GetAdminInfoNfp(nn::sf::Out<nn::nfp::AdminInfo> adminInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result GetRegisterInfoPrivateNfp(nn::sf::Out<nn::nfp::RegisterInfoPrivate> registerInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result SetRegisterInfoPrivateNfp(nn::nfc::DeviceHandle deviceHandle, const nn::nfp::RegisterInfoPrivate& registerInfo) NN_NOEXCEPT;
        nn::Result DeleteRegisterInfoNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result DeleteApplicationAreaNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result ExistsApplicationAreaNfp(nn::sf::Out<bool> flag, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result InitializeNfp(nn::applet::AppletResourceUserId aruid, nn::Bit64 pid, const nn::sf::InArray<nn::xcd::McuVersionDataForNfc>& mcuVersionData) NN_NOEXCEPT;
    nn::Result FinalizeNfp() NN_NOEXCEPT;
    nn::Result ListDevicesNfp(const nn::sf::OutArray<nn::nfc::DeviceHandle>& devices, nn::sf::Out<std::int32_t> count) NN_NOEXCEPT;
    nn::Result StartDetectionNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result StopDetectionNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result MountNfp(nn::nfc::DeviceHandle deviceHandle, nn::Bit32 modelType, nn::Bit32 mountTarget) NN_NOEXCEPT;
    nn::Result UnmountNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result FlushNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result RestoreNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetTagInfoNfp(nn::sf::Out<nn::nfc::TagInfo> tagInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetRegisterInfoNfp(nn::sf::Out<nn::nfp::RegisterInfo> registerInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetCommonInfoNfp(nn::sf::Out<nn::nfp::CommonInfo> commonInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetModelInfoNfp(nn::sf::Out<nn::nfp::ModelInfo> modelInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetActivateEventHandleNfp(nn::sf::Out<nn::sf::NativeHandle> handle, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetDeactivateEventHandleNfp(nn::sf::Out<nn::sf::NativeHandle> handle, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetStateNfp(nn::sf::Out<nn::Bit32> state) NN_NOEXCEPT;
    nn::Result GetDeviceStateNfp(nn::sf::Out<nn::Bit32> state, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetNpadIdNfp(nn::sf::Out<nn::hid::NpadIdType> npadId, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetAvailabilityChangeEventHandleNfp(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    nn::Result FormatNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetAdminInfoNfp(nn::sf::Out<nn::nfp::AdminInfo> adminInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetRegisterInfoPrivateNfp(nn::sf::Out<nn::nfp::RegisterInfoPrivate> registerInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result SetRegisterInfoPrivateNfp(nn::nfc::DeviceHandle deviceHandle, const nn::nfp::RegisterInfoPrivate& registerInfo) NN_NOEXCEPT;
    nn::Result DeleteRegisterInfoNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result DeleteApplicationAreaNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result ExistsApplicationAreaNfp(nn::sf::Out<bool> flag, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::nfp::detail::ISystem))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(InitializeNfp, (::nn::applet::AppletResourceUserId aruid, ::nn::Bit64 pid, const ::nn::sf::InArray<::nn::xcd::McuVersionDataForNfc>& mcuVersionData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(InitializeNfp, (aruid, pid, mcuVersionData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(FinalizeNfp)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(FinalizeNfp);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListDevicesNfp, (const ::nn::sf::OutArray<::nn::nfc::DeviceHandle>& devices, ::nn::sf::Out<::std::int32_t> count))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListDevicesNfp, (devices, count));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartDetectionNfp, (::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StartDetectionNfp, (deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StopDetectionNfp, (::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StopDetectionNfp, (deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(MountNfp, (::nn::nfc::DeviceHandle deviceHandle, ::nn::Bit32 modelType, ::nn::Bit32 mountTarget))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(MountNfp, (deviceHandle, modelType, mountTarget));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnmountNfp, (::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UnmountNfp, (deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FlushNfp, (::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(FlushNfp, (deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RestoreNfp, (::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RestoreNfp, (deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTagInfoNfp, (::nn::sf::Out<::nn::nfc::TagInfo> tagInfo, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetTagInfoNfp, (tagInfo, deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRegisterInfoNfp, (::nn::sf::Out<::nn::nfp::RegisterInfo> registerInfo, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetRegisterInfoNfp, (registerInfo, deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCommonInfoNfp, (::nn::sf::Out<::nn::nfp::CommonInfo> commonInfo, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetCommonInfoNfp, (commonInfo, deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetModelInfoNfp, (::nn::sf::Out<::nn::nfp::ModelInfo> modelInfo, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetModelInfoNfp, (modelInfo, deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetActivateEventHandleNfp, (::nn::sf::Out<::nn::sf::NativeHandle> handle, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetActivateEventHandleNfp, (handle, deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDeactivateEventHandleNfp, (::nn::sf::Out<::nn::sf::NativeHandle> handle, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDeactivateEventHandleNfp, (handle, deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetStateNfp, (::nn::sf::Out<::nn::Bit32> state))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetStateNfp, (state));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDeviceStateNfp, (::nn::sf::Out<::nn::Bit32> state, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDeviceStateNfp, (state, deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNpadIdNfp, (::nn::sf::Out<::nn::hid::NpadIdType> npadId, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetNpadIdNfp, (npadId, deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAvailabilityChangeEventHandleNfp, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAvailabilityChangeEventHandleNfp, (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FormatNfp, (::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(FormatNfp, (deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAdminInfoNfp, (::nn::sf::Out<::nn::nfp::AdminInfo> adminInfo, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAdminInfoNfp, (adminInfo, deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRegisterInfoPrivateNfp, (::nn::sf::Out<::nn::nfp::RegisterInfoPrivate> registerInfo, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetRegisterInfoPrivateNfp, (registerInfo, deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetRegisterInfoPrivateNfp, (::nn::nfc::DeviceHandle deviceHandle, const ::nn::nfp::RegisterInfoPrivate& registerInfo))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetRegisterInfoPrivateNfp, (deviceHandle, registerInfo));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteRegisterInfoNfp, (::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteRegisterInfoNfp, (deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteApplicationAreaNfp, (::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteApplicationAreaNfp, (deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ExistsApplicationAreaNfp, (::nn::sf::Out<bool> flag, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ExistsApplicationAreaNfp, (flag, deviceHandle));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::nfp::detail::ISystem>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::nfp::detail::ISystem))

    // nn::Result InitializeNfp(nn::applet::AppletResourceUserId aruid, nn::Bit64 pid, const nn::sf::InArray<nn::xcd::McuVersionDataForNfc>& mcuVersionData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(InitializeNfp)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(mcuVersionData, 0, (const ::nn::sf::InArray<::nn::xcd::McuVersionDataForNfc>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (mcuVersionData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pid, (::nn::Bit64), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (aruid, pid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mcuVersionData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(InitializeNfp)

    // nn::Result FinalizeNfp() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(FinalizeNfp)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(FinalizeNfp)

    // nn::Result ListDevicesNfp(const nn::sf::OutArray<nn::nfc::DeviceHandle>& devices, nn::sf::Out<std::int32_t> count) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListDevicesNfp)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(devices, 0, (const ::nn::sf::OutArray<::nn::nfc::DeviceHandle>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (devices))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(count, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (count))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(devices), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(count)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListDevicesNfp)

    // nn::Result StartDetectionNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartDetectionNfp)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartDetectionNfp)

    // nn::Result StopDetectionNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StopDetectionNfp)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StopDetectionNfp)

    // nn::Result MountNfp(nn::nfc::DeviceHandle deviceHandle, nn::Bit32 modelType, nn::Bit32 mountTarget) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(MountNfp)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(modelType, (::nn::Bit32), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(mountTarget, (::nn::Bit32), 12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (deviceHandle, modelType, mountTarget))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(modelType), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mountTarget)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(MountNfp)

    // nn::Result UnmountNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnmountNfp)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnmountNfp)

    // nn::Result FlushNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(FlushNfp)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(FlushNfp)

    // nn::Result RestoreNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RestoreNfp)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RestoreNfp)

    // nn::Result GetTagInfoNfp(nn::sf::Out<nn::nfc::TagInfo> tagInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetTagInfoNfp)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(tagInfo, 0, (::nn::sf::Out<::nn::nfc::TagInfo>), 88, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (tagInfo))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(tagInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetTagInfoNfp)

    // nn::Result GetRegisterInfoNfp(nn::sf::Out<nn::nfp::RegisterInfo> registerInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetRegisterInfoNfp)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(14)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(registerInfo, 0, (::nn::sf::Out<::nn::nfp::RegisterInfo>), 256, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (registerInfo))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(registerInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetRegisterInfoNfp)

    // nn::Result GetCommonInfoNfp(nn::sf::Out<nn::nfp::CommonInfo> commonInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetCommonInfoNfp)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(15)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(commonInfo, 0, (::nn::sf::Out<::nn::nfp::CommonInfo>), 64, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (commonInfo))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(commonInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetCommonInfoNfp)

    // nn::Result GetModelInfoNfp(nn::sf::Out<nn::nfp::ModelInfo> modelInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetModelInfoNfp)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(modelInfo, 0, (::nn::sf::Out<::nn::nfp::ModelInfo>), 64, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (modelInfo))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(modelInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetModelInfoNfp)

    // nn::Result GetActivateEventHandleNfp(nn::sf::Out<nn::sf::NativeHandle> handle, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetActivateEventHandleNfp)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(17)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetActivateEventHandleNfp)

    // nn::Result GetDeactivateEventHandleNfp(nn::sf::Out<nn::sf::NativeHandle> handle, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDeactivateEventHandleNfp)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(18)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDeactivateEventHandleNfp)

    // nn::Result GetStateNfp(nn::sf::Out<nn::Bit32> state) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetStateNfp)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(19)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(state, (::nn::Bit32), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (state))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(state)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetStateNfp)

    // nn::Result GetDeviceStateNfp(nn::sf::Out<nn::Bit32> state, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDeviceStateNfp)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(state, (::nn::Bit32), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (state))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(state), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDeviceStateNfp)

    // nn::Result GetNpadIdNfp(nn::sf::Out<nn::hid::NpadIdType> npadId, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNpadIdNfp)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(21)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(npadId, (::nn::hid::NpadIdType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (npadId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(npadId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNpadIdNfp)

    // nn::Result GetAvailabilityChangeEventHandleNfp(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAvailabilityChangeEventHandleNfp)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(23)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAvailabilityChangeEventHandleNfp)

    // nn::Result FormatNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(FormatNfp)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(100)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(FormatNfp)

    // nn::Result GetAdminInfoNfp(nn::sf::Out<nn::nfp::AdminInfo> adminInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAdminInfoNfp)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(101)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(adminInfo, 0, (::nn::sf::Out<::nn::nfp::AdminInfo>), 64, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (adminInfo))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(adminInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAdminInfoNfp)

    // nn::Result GetRegisterInfoPrivateNfp(nn::sf::Out<nn::nfp::RegisterInfoPrivate> registerInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetRegisterInfoPrivateNfp)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(102)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(registerInfo, 0, (::nn::sf::Out<::nn::nfp::RegisterInfoPrivate>), 256, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (registerInfo))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(registerInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetRegisterInfoPrivateNfp)

    // nn::Result SetRegisterInfoPrivateNfp(nn::nfc::DeviceHandle deviceHandle, const nn::nfp::RegisterInfoPrivate& registerInfo) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetRegisterInfoPrivateNfp)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(103)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(registerInfo, 0, (const ::nn::nfp::RegisterInfoPrivate&), 256, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (registerInfo))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(registerInfo)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetRegisterInfoPrivateNfp)

    // nn::Result DeleteRegisterInfoNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteRegisterInfoNfp)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(104)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteRegisterInfoNfp)

    // nn::Result DeleteApplicationAreaNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteApplicationAreaNfp)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(105)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteApplicationAreaNfp)

    // nn::Result ExistsApplicationAreaNfp(nn::sf::Out<bool> flag, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ExistsApplicationAreaNfp)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(106)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(flag, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (flag))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(flag), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ExistsApplicationAreaNfp)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::applet::AppletResourceUserId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::xcd::McuVersionDataForNfc), 32, 2)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nfc::DeviceHandle), 8, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nfc::TagInfo), 88, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nfp::RegisterInfo), 256, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nfp::CommonInfo), 64, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nfp::ModelInfo), 64, 2)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::NpadIdType), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nfp::AdminInfo), 64, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nfp::RegisterInfoPrivate), 256, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::nfp::detail::ISystem, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::nfp::detail::ISystem))

    // nn::Result InitializeNfp(nn::applet::AppletResourceUserId aruid, nn::Bit64 pid, const nn::sf::InArray<nn::xcd::McuVersionDataForNfc>& mcuVersionData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(InitializeNfp, (::nn::applet::AppletResourceUserId aruid, ::nn::Bit64 pid, const ::nn::sf::InArray<::nn::xcd::McuVersionDataForNfc>& mcuVersionData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(InitializeNfp)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mcuVersionData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(InitializeNfp)
    }

    // nn::Result FinalizeNfp() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(FinalizeNfp)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(FinalizeNfp)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(FinalizeNfp)
    }

    // nn::Result ListDevicesNfp(const nn::sf::OutArray<nn::nfc::DeviceHandle>& devices, nn::sf::Out<std::int32_t> count) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListDevicesNfp, (const ::nn::sf::OutArray<::nn::nfc::DeviceHandle>& devices, ::nn::sf::Out<::std::int32_t> count))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListDevicesNfp)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(devices)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(count)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListDevicesNfp)
    }

    // nn::Result StartDetectionNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartDetectionNfp, (::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartDetectionNfp)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartDetectionNfp)
    }

    // nn::Result StopDetectionNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StopDetectionNfp, (::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StopDetectionNfp)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StopDetectionNfp)
    }

    // nn::Result MountNfp(nn::nfc::DeviceHandle deviceHandle, nn::Bit32 modelType, nn::Bit32 mountTarget) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(MountNfp, (::nn::nfc::DeviceHandle deviceHandle, ::nn::Bit32 modelType, ::nn::Bit32 mountTarget))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(MountNfp)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(modelType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mountTarget)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(MountNfp)
    }

    // nn::Result UnmountNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnmountNfp, (::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnmountNfp)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnmountNfp)
    }

    // nn::Result FlushNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FlushNfp, (::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(FlushNfp)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(FlushNfp)
    }

    // nn::Result RestoreNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RestoreNfp, (::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RestoreNfp)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RestoreNfp)
    }

    // nn::Result GetTagInfoNfp(nn::sf::Out<nn::nfc::TagInfo> tagInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTagInfoNfp, (::nn::sf::Out<::nn::nfc::TagInfo> tagInfo, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetTagInfoNfp)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(tagInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetTagInfoNfp)
    }

    // nn::Result GetRegisterInfoNfp(nn::sf::Out<nn::nfp::RegisterInfo> registerInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRegisterInfoNfp, (::nn::sf::Out<::nn::nfp::RegisterInfo> registerInfo, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetRegisterInfoNfp)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(registerInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetRegisterInfoNfp)
    }

    // nn::Result GetCommonInfoNfp(nn::sf::Out<nn::nfp::CommonInfo> commonInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCommonInfoNfp, (::nn::sf::Out<::nn::nfp::CommonInfo> commonInfo, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetCommonInfoNfp)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(commonInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetCommonInfoNfp)
    }

    // nn::Result GetModelInfoNfp(nn::sf::Out<nn::nfp::ModelInfo> modelInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetModelInfoNfp, (::nn::sf::Out<::nn::nfp::ModelInfo> modelInfo, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetModelInfoNfp)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(modelInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetModelInfoNfp)
    }

    // nn::Result GetActivateEventHandleNfp(nn::sf::Out<nn::sf::NativeHandle> handle, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetActivateEventHandleNfp, (::nn::sf::Out<::nn::sf::NativeHandle> handle, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetActivateEventHandleNfp)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetActivateEventHandleNfp)
    }

    // nn::Result GetDeactivateEventHandleNfp(nn::sf::Out<nn::sf::NativeHandle> handle, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDeactivateEventHandleNfp, (::nn::sf::Out<::nn::sf::NativeHandle> handle, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDeactivateEventHandleNfp)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDeactivateEventHandleNfp)
    }

    // nn::Result GetStateNfp(nn::sf::Out<nn::Bit32> state) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetStateNfp, (::nn::sf::Out<::nn::Bit32> state))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetStateNfp)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(state)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetStateNfp)
    }

    // nn::Result GetDeviceStateNfp(nn::sf::Out<nn::Bit32> state, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDeviceStateNfp, (::nn::sf::Out<::nn::Bit32> state, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDeviceStateNfp)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(state)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDeviceStateNfp)
    }

    // nn::Result GetNpadIdNfp(nn::sf::Out<nn::hid::NpadIdType> npadId, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNpadIdNfp, (::nn::sf::Out<::nn::hid::NpadIdType> npadId, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNpadIdNfp)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(npadId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNpadIdNfp)
    }

    // nn::Result GetAvailabilityChangeEventHandleNfp(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAvailabilityChangeEventHandleNfp, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAvailabilityChangeEventHandleNfp)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAvailabilityChangeEventHandleNfp)
    }

    // nn::Result FormatNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FormatNfp, (::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(FormatNfp)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(FormatNfp)
    }

    // nn::Result GetAdminInfoNfp(nn::sf::Out<nn::nfp::AdminInfo> adminInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAdminInfoNfp, (::nn::sf::Out<::nn::nfp::AdminInfo> adminInfo, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAdminInfoNfp)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(adminInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAdminInfoNfp)
    }

    // nn::Result GetRegisterInfoPrivateNfp(nn::sf::Out<nn::nfp::RegisterInfoPrivate> registerInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRegisterInfoPrivateNfp, (::nn::sf::Out<::nn::nfp::RegisterInfoPrivate> registerInfo, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetRegisterInfoPrivateNfp)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(registerInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetRegisterInfoPrivateNfp)
    }

    // nn::Result SetRegisterInfoPrivateNfp(nn::nfc::DeviceHandle deviceHandle, const nn::nfp::RegisterInfoPrivate& registerInfo) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetRegisterInfoPrivateNfp, (::nn::nfc::DeviceHandle deviceHandle, const ::nn::nfp::RegisterInfoPrivate& registerInfo))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetRegisterInfoPrivateNfp)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(registerInfo)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetRegisterInfoPrivateNfp)
    }

    // nn::Result DeleteRegisterInfoNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteRegisterInfoNfp, (::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteRegisterInfoNfp)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteRegisterInfoNfp)
    }

    // nn::Result DeleteApplicationAreaNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteApplicationAreaNfp, (::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteApplicationAreaNfp)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteApplicationAreaNfp)
    }

    // nn::Result ExistsApplicationAreaNfp(nn::sf::Out<bool> flag, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ExistsApplicationAreaNfp, (::nn::sf::Out<bool> flag, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ExistsApplicationAreaNfp)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(flag)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ExistsApplicationAreaNfp)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::nfp::detail::ISystem>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::nfp::detail::ISystem))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(InitializeNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(mcuVersionData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(InitializeNfp)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(mcuVersionData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(FinalizeNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(FinalizeNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListDevicesNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(devices)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListDevicesNfp)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(devices),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(count)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartDetectionNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartDetectionNfp)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StopDetectionNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StopDetectionNfp)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(MountNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(MountNfp)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(modelType),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(mountTarget)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnmountNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnmountNfp)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(FlushNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(FlushNfp)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RestoreNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RestoreNfp)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetTagInfoNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(tagInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetTagInfoNfp)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(tagInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetRegisterInfoNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(registerInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetRegisterInfoNfp)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(registerInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetCommonInfoNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(commonInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetCommonInfoNfp)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(commonInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetModelInfoNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(modelInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetModelInfoNfp)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(modelInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetActivateEventHandleNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetActivateEventHandleNfp)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDeactivateEventHandleNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDeactivateEventHandleNfp)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetStateNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetStateNfp)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(state)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDeviceStateNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDeviceStateNfp)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(state),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNpadIdNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNpadIdNfp)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(npadId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAvailabilityChangeEventHandleNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAvailabilityChangeEventHandleNfp)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(FormatNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(FormatNfp)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAdminInfoNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(adminInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAdminInfoNfp)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(adminInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetRegisterInfoPrivateNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(registerInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetRegisterInfoPrivateNfp)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(registerInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetRegisterInfoPrivateNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(registerInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetRegisterInfoPrivateNfp)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(registerInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteRegisterInfoNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteRegisterInfoNfp)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteApplicationAreaNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteApplicationAreaNfp)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ExistsApplicationAreaNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ExistsApplicationAreaNfp)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(flag),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(InitializeNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(FinalizeNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListDevicesNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartDetectionNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StopDetectionNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(MountNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnmountNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(FlushNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RestoreNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetTagInfoNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetRegisterInfoNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetCommonInfoNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetModelInfoNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetActivateEventHandleNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDeactivateEventHandleNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetStateNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDeviceStateNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNpadIdNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAvailabilityChangeEventHandleNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(FormatNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAdminInfoNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetRegisterInfoPrivateNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetRegisterInfoPrivateNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteRegisterInfoNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteApplicationAreaNfp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ExistsApplicationAreaNfp)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::nfp::detail::ISystem))

namespace nn { namespace nfp { namespace detail { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(ISystemManager, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(ISystemManager)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateSystemInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::nfp::detail::ISystem>> pOutSystemInterface))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(ISystemManager)

        ::nn::Result CreateSystemInterface(::nn::sf::Out<::nn::sf::SharedPointer<::nn::nfp::detail::ISystem>> pOutSystemInterface) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateSystemInterface, (pOutSystemInterface));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class ISystemManager
    {
    public:
        nn::Result CreateSystemInterface(nn::sf::Out<nn::sf::SharedPointer<nn::nfp::detail::ISystem>> pOutSystemInterface) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result CreateSystemInterface(nn::sf::Out<nn::sf::SharedPointer<nn::nfp::detail::ISystem>> pOutSystemInterface) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::nfp::detail::ISystemManager))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateSystemInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::nfp::detail::ISystem>> pOutSystemInterface))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateSystemInterface, (pOutSystemInterface));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::nfp::detail::ISystemManager>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::nfp::detail::ISystemManager))

    // nn::Result CreateSystemInterface(nn::sf::Out<nn::sf::SharedPointer<nn::nfp::detail::ISystem>> pOutSystemInterface) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateSystemInterface)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutSystemInterface, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutSystemInterface))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSystemInterface)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateSystemInterface)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::nfp::detail::ISystemManager, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::nfp::detail::ISystemManager))

    // nn::Result CreateSystemInterface(nn::sf::Out<nn::sf::SharedPointer<nn::nfp::detail::ISystem>> pOutSystemInterface) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateSystemInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::nfp::detail::ISystem>> pOutSystemInterface))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateSystemInterface)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSystemInterface)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateSystemInterface)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::nfp::detail::ISystemManager>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::nfp::detail::ISystemManager))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateSystemInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::nfp::detail::ISystem>), pOutSystemInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateSystemInterface)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutSystemInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutSystemInterface, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateSystemInterface)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::nfp::detail::ISystemManager))
