﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/news/detail/ipc/news_INewsDataService.sfdl.h>
#include <nn/fs.h>

namespace nn { namespace news { namespace detail { namespace service {

/*!
    @brief      データサービスです。
*/
class NewsDataServiceForGeneric
{
public:
    /*!
        @brief      コンストラクタです。
    */
    NewsDataServiceForGeneric() NN_NOEXCEPT;

    /*!
        @brief      デストラクタです。
    */
    ~NewsDataServiceForGeneric() NN_NOEXCEPT;

public:
    // INewsDataService
    nn::Result Open(const nn::sf::InArray<char>& name) NN_NOEXCEPT;
    nn::Result OpenWithNewsRecord(const nn::news::NewsRecord& record) NN_NOEXCEPT;
    nn::Result OpenWithNewsRecordV1(const nn::news::NewsRecordV1& record) NN_NOEXCEPT;
    nn::Result Read(nn::sf::Out<std::uint64_t> outSize, std::int64_t offset, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT;
    nn::Result GetSize(nn::sf::Out<std::int64_t> outSize) NN_NOEXCEPT;

private:
    //
    nn::fs::FileHandle m_Handle;
    bool m_IsOpened;
};

}}}}
