﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/news/detail/ipc/news_INewlyArrivedEventHolder.sfdl.h>
#include <nn/news/detail/service/news_ServiceMemoryManager.h>
#include <nn/os.h>

namespace nn { namespace news { namespace detail { namespace service {

/*!
    @brief      新着イベントホルダーです。
*/
class NewlyArrivedEventHolder
{
public:
    /*!
        @brief      コンストラクタです。
    */
    NewlyArrivedEventHolder() NN_NOEXCEPT;

    /*!
        @brief      デストラクタです。
    */
    ~NewlyArrivedEventHolder() NN_NOEXCEPT;

public:
    // INewlyArrivedEventHolder
    nn::Result Get(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;

private:
    //
    nn::os::SystemEvent m_Event;
};

NN_STATIC_ASSERT(sizeof (NewlyArrivedEventHolder) <= detail::service::ServiceMemoryManager::NewlyArrivedEventHolderSize);

}}}}
