﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace news { namespace detail { namespace ipc {

//// NewsService

/*!
    @brief      1 プロセスあたりの NewsService 数です。
*/
const int NewsServiceCountPerProcess = 1;

/*!
    @brief      NewsService を利用するプロセス同時接続数です。
*/
const int NewsServiceProcessCountMax = 4;

/*!
    @brief      NewsService の最大数です。
*/
const int NewsServiceCountMax = NewsServiceCountPerProcess * NewsServiceProcessCountMax;

//// NewlyArrivedEventHolder

/*!
    @brief      1 プロセスあたりの NewlyArrivedEventHolder 数です。
*/
const int NewlyArrivedEventHolderCountPerProcess = 1;

/*!
    @brief      NewlyArrivedEventHolder を利用するプロセス同時接続数です。
*/
const int NewlyArrivedEventHolderProcessCountMax = 4;

/*!
    @brief      NewlyArrivedEventHolder の最大数です。
*/
const int NewlyArrivedEventHolderCountMax = NewlyArrivedEventHolderCountPerProcess * NewlyArrivedEventHolderProcessCountMax;

//// OverwriteEventHolder

/*!
    @brief      1 プロセスあたりの OverwriteEventHolder 数です。
*/
const int OverwriteEventHolderCountPerProcess = 1;

/*!
    @brief      OverwriteEventHolder を利用するプロセス同時接続数です。
*/
const int OverwriteEventHolderProcessCountMax = 4;

/*!
    @brief      OverwriteEventHolder の最大数です。
*/
const int OverwriteEventHolderCountMax = OverwriteEventHolderCountPerProcess * OverwriteEventHolderProcessCountMax;

//// NewsDataService

/*!
    @brief      1 プロセスあたりの NewsDataService 数です。
*/
const int NewsDataServiceCountPerProcess = 8;

/*!
    @brief      NewsDataService を利用するプロセス同時接続数です。
*/
const int NewsDataServiceProcessCountMax = 2;

/*!
    @brief      NewsDataService の最大数です。
*/
const int NewsDataServiceCountMax = NewsDataServiceCountPerProcess * NewsDataServiceProcessCountMax;

//// NewsDatabaseService

/*!
    @brief      1 プロセスあたりの NewsDatabaseService 数です。
*/
const int NewsDatabaseServiceCountPerProcess = 2;

/*!
    @brief      NewsDatabaseService を利用するプロセス同時接続数です。
*/
const int NewsDatabaseServiceProcessCountMax = 2;

/*!
    @brief      NewsDatabaseService の最大数です。
*/
const int NewsDatabaseServiceCountMax = NewsDatabaseServiceCountPerProcess * NewsDatabaseServiceProcessCountMax;

//// Session

/*!
    @brief      1 プロセスあたりのセッション数です。
*/
const int SessionCountPerProcess = 1;

/*!
    @brief      システムが提供するセッション数です。
*/
const int SessionCountMax = 8;

//// Object

/*!
    @brief      1 プロセスあたりのオブジェクト数です。

    @details
                サービス生成器＋各オブジェクトの総数 になります。
*/
const int ObjectCountPerProcess = 1 +
    NewsServiceCountPerProcess +
    NewlyArrivedEventHolderCountPerProcess +
    OverwriteEventHolderCountPerProcess +
    NewsDataServiceCountPerProcess +
    NewsDatabaseServiceCountPerProcess;

}}}}
