﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief NATタイプ判定の API
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/netdiag/netdiag_NatTypes.h>

namespace nn { namespace netdiag {

    /**
     * @name    NAT タイプ判定
     * @{
     */

    /**
     * @brief   NAT タイプ判定を行います。
     *
     * @param[out]   pType  判定した結果を格納します。
     *
     * @retresult
     *      @handleresult{ResultFailedNetwork, ネットワーク接続に失敗して判定できませんでした。}
     *      @handleresult{ResultInterrupted, InterruptDetectNatType() によって処理が中断されました。}
     * @endretresult
     *
     * @pre
     *  - nifm ライブラリが初期化済
     *  - socket ライブラリが初期化済
     *
     * @details
     *  判定に成功すると、
     *  NAT タイプとして nn::netdiag::NatType_A 、nn::netdiag::NatType_B 、nn::netdiag::NatType_C 、
     *  nn::netdiag::NatType_D 、nn::netdiag::NatType_Z のいずれかが返ります。
     *
     *  判定の途中で中断する場合は、nn::netdiag::InterruptDetectnatType() を呼んでください。
     */
    Result DetectNatType( NatType* pType ) NN_NOEXCEPT;

    /**
     * @brief   NAT タイプ判定の中断指示を出します。
     *
     * @details
     *    nn::netdiag::DetectNatType() の NAT タイプ判定処理を中断します。
     *    この関数でブロックされることはありません。
     *    NAT タイプ判定を行っていないときにこの関数を呼んだ場合、何も行いません。
     */
     void InterruptDetectNatType() NN_NOEXCEPT;

    /**
     * @}
     */

}} // nn::netdiag
