﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/mii/detail/service/mii_ServiceCommon.h>
#include <nn/mii/detail/service/mii_StaticServiceInterface.h>
#include <nn/mii/detail/service/mii_IStaticService.sfdl.h>
#include <nn/mii/detail/service/mii_ImageDatabaseServiceInterface.h>
#include <nn/mii/detail/service/mii_IImageDatabaseService.sfdl.h>

#include <nn/sf/sf_HipcSimpleAllInOneServerManager.h>
#include <nn/sf/sf_ExpHeapAllocator.h>
#include <nn/sf/sf_ObjectFactory.h>


namespace nn
{
namespace mii
{
namespace detail
{

class ServiceProvider;

const int SessionCountMaxForUser = 5;
const int SessionCountMaxForEditor = 5;
const int SessionCountMaxForImageUserService = 5;
const int SessionCountMax =
    SessionCountMaxForUser + SessionCountMaxForEditor + SessionCountMaxForImageUserService;

// 1プロセスが 1 サブドメイン想定
struct HipcSimpleAllInOneServerManagerOptions
{
    static const size_t PointerTransferBufferSize = 128; // sizeof(nn::mii::CharInfo) = 88 byte が最大
    static const int SubDomainCountMax = SessionCountMax * 1; // サブドメインの最大数(1 プロセスが 1 サブドメイン)
    static const int ObjectInSubDomainCountMax = SessionCountMax * 2; // 各サブドメインが登録できるサービスオブジェクトの数は平均 2 つとする
};

// HipcSimpleAllInOneServerManager の SessionCountMax は実際に必要となる HIPC の2倍あれば足りる
class HipcServerManager : public nn::sf::HipcSimpleAllInOneServerManager<SessionCountMax * 2, 3, HipcSimpleAllInOneServerManagerOptions>
{
private:
    class SfExpHeapAllocator
    {
    private:
        char m_Buffer[16 * 1024];
        nn::sf::ExpHeapAllocator m_ExpHeapAllocator;

    public:
        explicit SfExpHeapAllocator(nn::lmem::CreationOption option) NN_NOEXCEPT;
        nn::sf::ExpHeapAllocator* GetBase() NN_NOEXCEPT;
    } m_SfExpHeapAllocator;

    nn::sf::UnmanagedServiceObject<IStaticService, StaticServiceInterface> m_UserStaticService;
    nn::sf::UnmanagedServiceObject<IStaticService, StaticServiceInterface> m_EditorStaticService;
    nn::sf::UnmanagedServiceObject<IImageDatabaseService, ImageDatabaseServiceInterface> m_ImageDatabaseStaticService;

public:
    explicit HipcServerManager(ServiceProvider* pServiceProvider) NN_NOEXCEPT;
    ~HipcServerManager() NN_NOEXCEPT;

    nn::sf::UnmanagedServiceObject<IStaticService, StaticServiceInterface>& GetEditorStaticService()
    {
        return m_EditorStaticService;
    }

    nn::sf::UnmanagedServiceObject<IImageDatabaseService, ImageDatabaseServiceInterface>& GetImageDatabaseStaticService()
    {
        return m_ImageDatabaseStaticService;
    }
};

}
}
}
