﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/lidbe/lidbe_Types.h>


namespace nn { namespace lidbe {

    struct ApplicationTitle
    {
        uint16_t    shortName[IdbeShortNameLength];   //!< 短いタイトル名です。
        uint16_t    longName[IdbeLongNameLength];     //!< 長いタイトル名です。
        uint16_t    publisher[IdbePublisherLength];   //!< パブリッシャ名です。
    };

    struct ApplicationIdbeProperty
    {
        static const int MaxLanguageCount = 16;

        ApplicationTitle title[MaxLanguageCount];        //!< 言語ごとのタイトルです。

        /**
        * @brief    本体言語設定を参照してタイトル情報を取得します。
        *
        *           本体言語設定にマッチするタイトル情報を取得します。
        *           見つからなかった場合、言語優先順位に従って探索し、見つかったものを取得します。
        *
        * @return   タイトル情報が返ります。タイトル情報が１つも見つからない場合は空文字列が返ります。
        */
        const ApplicationTitle& GetDefaultTitle() const NN_NOEXCEPT;

    };

    class ApplicationIdbeAccessor
    {
    public:
        /**
        * @brief    アプリケーション管理データの初期化を行います。
        */
        void Initialize(void* data, size_t size) NN_NOEXCEPT;

        /**
        * @brief    アプリケーション管理データを取得します。
        */
        const ApplicationIdbeProperty& GetProperty() const NN_NOEXCEPT;

        /**
        * @brief    アプリケーションのアイコンデータを取得します。
        */
        const void* GetIconData() const NN_NOEXCEPT;

        /**
        * @brief    アプリケーションのアイコンサイズを取得します。
        */
        size_t GetIconSize() const NN_NOEXCEPT;

    private:
        void* m_Data;
        size_t m_Size;
    };


}}  // namespace nn::lidbe
