﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   LBL ライブラリの自動輝度制御スレッド向け機能の API 宣言。
 */

#pragma once

#include <nn/nn_Common.h>

namespace nn {
namespace lbl {
namespace impl {

/**
 * @brief 自動輝度調整モードにおける輝度の更新を行います。
 *
 * @pre         初期化されている必要があります。
 * @details     自動輝度調整モードにおける輝度の更新を行います。自動輝度調整スレッドにより定期的に呼ばれることを想定しています。
 */
void UpdateBrightness() NN_NOEXCEPT;

} // impl
} // lbl
} // nn


