﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/jit/jit_CommonTypes.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace jitsrv { // NOLINT(whitespace/braces)

class IJitEnvironment;

class IJitEnvironmentBase;

class IJitService;

struct Struct32;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IJitEnvironmentBase, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IJitEnvironmentBase)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LoadPlugin, (const ::nn::sf::InBuffer& nrr, const ::nn::sf::InBuffer& nro, ::nn::sf::NativeHandle&& workMemory, ::std::uint64_t workMemorySize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetCodeAddress, (::nn::sf::Out<::std::uint64_t> pRxCodeAddress, ::nn::sf::Out<::std::uint64_t> pRoCodeAddress))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IJitEnvironmentBase)

        ::nn::Result LoadPlugin(const ::nn::sf::InBuffer& nrr, const ::nn::sf::InBuffer& nro, ::nn::sf::NativeHandle&& workMemory, ::std::uint64_t workMemorySize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LoadPlugin, (nrr, nro, ::std::move(workMemory), workMemorySize));
        }

        ::nn::Result GetCodeAddress(::nn::sf::Out<::std::uint64_t> pRxCodeAddress, ::nn::sf::Out<::std::uint64_t> pRoCodeAddress) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetCodeAddress, (pRxCodeAddress, pRoCodeAddress));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IJitEnvironmentBase
    {
    public:
        nn::Result LoadPlugin(const nn::sf::InBuffer& nrr, const nn::sf::InBuffer& nro, nn::sf::NativeHandle&& workMemory, std::uint64_t workMemorySize) NN_NOEXCEPT;
        nn::Result GetCodeAddress(nn::sf::Out<std::uint64_t> pRxCodeAddress, nn::sf::Out<std::uint64_t> pRoCodeAddress) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result LoadPlugin(const nn::sf::InBuffer& nrr, const nn::sf::InBuffer& nro, nn::sf::NativeHandle&& workMemory, std::uint64_t workMemorySize) NN_NOEXCEPT;
    nn::Result GetCodeAddress(nn::sf::Out<std::uint64_t> pRxCodeAddress, nn::sf::Out<std::uint64_t> pRoCodeAddress) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::jitsrv::IJitEnvironmentBase))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadPlugin, (const ::nn::sf::InBuffer& nrr, const ::nn::sf::InBuffer& nro, ::nn::sf::NativeHandle&& workMemory, ::std::uint64_t workMemorySize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LoadPlugin, (nrr, nro, ::std::move(workMemory), workMemorySize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCodeAddress, (::nn::sf::Out<::std::uint64_t> pRxCodeAddress, ::nn::sf::Out<::std::uint64_t> pRoCodeAddress))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetCodeAddress, (pRxCodeAddress, pRoCodeAddress));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::jitsrv::IJitEnvironmentBase>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::jitsrv::IJitEnvironmentBase))

    // nn::Result LoadPlugin(const nn::sf::InBuffer& nrr, const nn::sf::InBuffer& nro, nn::sf::NativeHandle&& workMemory, std::uint64_t workMemorySize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LoadPlugin)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1000)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(nrr, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(nro, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (nrr, nro))

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(workMemory, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(1, (workMemory))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(workMemorySize, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (workMemorySize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(nrr), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(nro), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(workMemory), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(workMemorySize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LoadPlugin)

    // nn::Result GetCodeAddress(nn::sf::Out<std::uint64_t> pRxCodeAddress, nn::sf::Out<std::uint64_t> pRoCodeAddress) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetCodeAddress)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1001)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pRxCodeAddress, (::std::uint64_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pRoCodeAddress, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pRxCodeAddress, pRoCodeAddress))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pRxCodeAddress), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pRoCodeAddress)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetCodeAddress)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::jitsrv::IJitEnvironmentBase, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::jitsrv::IJitEnvironmentBase))

    // nn::Result LoadPlugin(const nn::sf::InBuffer& nrr, const nn::sf::InBuffer& nro, nn::sf::NativeHandle&& workMemory, std::uint64_t workMemorySize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadPlugin, (const ::nn::sf::InBuffer& nrr, const ::nn::sf::InBuffer& nro, ::nn::sf::NativeHandle&& workMemory, ::std::uint64_t workMemorySize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LoadPlugin)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(nrr)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(nro)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(workMemory)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(workMemorySize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LoadPlugin)
    }

    // nn::Result GetCodeAddress(nn::sf::Out<std::uint64_t> pRxCodeAddress, nn::sf::Out<std::uint64_t> pRoCodeAddress) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCodeAddress, (::nn::sf::Out<::std::uint64_t> pRxCodeAddress, ::nn::sf::Out<::std::uint64_t> pRoCodeAddress))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetCodeAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pRxCodeAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pRoCodeAddress)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetCodeAddress)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::jitsrv::IJitEnvironmentBase>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::jitsrv::IJitEnvironmentBase))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LoadPlugin)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(nrr)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(nro)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(workMemory)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LoadPlugin)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(nrr),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(nro),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(workMemory),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(workMemorySize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetCodeAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetCodeAddress)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pRxCodeAddress),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pRoCodeAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LoadPlugin)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetCodeAddress)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::jitsrv::IJitEnvironmentBase))

namespace nn { namespace jitsrv { // NOLINT(whitespace/braces)

struct Struct32
{
    std::uint64_t m0;
    std::uint64_t m1;
    std::uint64_t m2;
    std::uint64_t m3;
};

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IJitEnvironment, (::nn::jitsrv::IJitEnvironmentBase))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IJitEnvironment)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GenerateCode, (::nn::sf::Out<::std::int32_t> pOut, ::nn::sf::Out<::nn::jit::CodeRange> pGeneratedRx, ::nn::sf::Out<::nn::jit::CodeRange> pGeneratedRo, const ::nn::sf::InBuffer& source, ::std::uint64_t tag, const ::nn::jit::CodeRange& rxRange, const ::nn::jit::CodeRange& roRange, const ::nn::jitsrv::Struct32& inData, ::std::uint32_t inDataSize, const ::nn::sf::OutBuffer& outBuffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Control, (::nn::sf::Out<::std::int32_t> pOut, ::std::uint64_t tag, const ::nn::sf::InBuffer& inData, const ::nn::sf::OutBuffer& outData))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IJitEnvironment)

        ::nn::Result GenerateCode(::nn::sf::Out<::std::int32_t> pOut, ::nn::sf::Out<::nn::jit::CodeRange> pGeneratedRx, ::nn::sf::Out<::nn::jit::CodeRange> pGeneratedRo, const ::nn::sf::InBuffer& source, ::std::uint64_t tag, const ::nn::jit::CodeRange& rxRange, const ::nn::jit::CodeRange& roRange, const ::nn::jitsrv::Struct32& inData, ::std::uint32_t inDataSize, const ::nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GenerateCode, (pOut, pGeneratedRx, pGeneratedRo, source, tag, rxRange, roRange, inData, inDataSize, outBuffer));
        }

        ::nn::Result Control(::nn::sf::Out<::std::int32_t> pOut, ::std::uint64_t tag, const ::nn::sf::InBuffer& inData, const ::nn::sf::OutBuffer& outData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Control, (pOut, tag, inData, outData));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IJitEnvironment : public ::nn::jitsrv::IJitEnvironmentBase
    {
    public:
        nn::Result GenerateCode(nn::sf::Out<std::int32_t> pOut, nn::sf::Out<nn::jit::CodeRange> pGeneratedRx, nn::sf::Out<nn::jit::CodeRange> pGeneratedRo, const nn::sf::InBuffer& source, std::uint64_t tag, const nn::jit::CodeRange& rxRange, const nn::jit::CodeRange& roRange, const nn::jitsrv::Struct32& inData, std::uint32_t inDataSize, const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT;
        nn::Result Control(nn::sf::Out<std::int32_t> pOut, std::uint64_t tag, const nn::sf::InBuffer& inData, const nn::sf::OutBuffer& outData) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GenerateCode(nn::sf::Out<std::int32_t> pOut, nn::sf::Out<nn::jit::CodeRange> pGeneratedRx, nn::sf::Out<nn::jit::CodeRange> pGeneratedRo, const nn::sf::InBuffer& source, std::uint64_t tag, const nn::jit::CodeRange& rxRange, const nn::jit::CodeRange& roRange, const nn::jitsrv::Struct32& inData, std::uint32_t inDataSize, const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT;
    nn::Result Control(nn::sf::Out<std::int32_t> pOut, std::uint64_t tag, const nn::sf::InBuffer& inData, const nn::sf::OutBuffer& outData) NN_NOEXCEPT;
    nn::Result LoadPlugin(const nn::sf::InBuffer& nrr, const nn::sf::InBuffer& nro, nn::sf::NativeHandle&& workMemory, std::uint64_t workMemorySize) NN_NOEXCEPT;
    nn::Result GetCodeAddress(nn::sf::Out<std::uint64_t> pRxCodeAddress, nn::sf::Out<std::uint64_t> pRoCodeAddress) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_WITH_BASE((::nn::jitsrv::IJitEnvironment), (::nn::jitsrv::IJitEnvironmentBase))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GenerateCode, (::nn::sf::Out<::std::int32_t> pOut, ::nn::sf::Out<::nn::jit::CodeRange> pGeneratedRx, ::nn::sf::Out<::nn::jit::CodeRange> pGeneratedRo, const ::nn::sf::InBuffer& source, ::std::uint64_t tag, const ::nn::jit::CodeRange& rxRange, const ::nn::jit::CodeRange& roRange, const ::nn::jitsrv::Struct32& inData, ::std::uint32_t inDataSize, const ::nn::sf::OutBuffer& outBuffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GenerateCode, (pOut, pGeneratedRx, pGeneratedRo, source, tag, rxRange, roRange, inData, inDataSize, outBuffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Control, (::nn::sf::Out<::std::int32_t> pOut, ::std::uint64_t tag, const ::nn::sf::InBuffer& inData, const ::nn::sf::OutBuffer& outData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Control, (pOut, tag, inData, outData));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::jitsrv::IJitEnvironment>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_WITH_BASE((::nn::jitsrv::IJitEnvironment), (::nn::jitsrv::IJitEnvironmentBase))

    // nn::Result GenerateCode(nn::sf::Out<std::int32_t> pOut, nn::sf::Out<nn::jit::CodeRange> pGeneratedRx, nn::sf::Out<nn::jit::CodeRange> pGeneratedRo, const nn::sf::InBuffer& source, std::uint64_t tag, const nn::jit::CodeRange& rxRange, const nn::jit::CodeRange& roRange, const nn::jitsrv::Struct32& inData, std::uint32_t inDataSize, const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GenerateCode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(source, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (source, outBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(inDataSize, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(tag, (::std::uint64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(rxRange, (::nn::jit::CodeRange), 16)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(roRange, (::nn::jit::CodeRange), 32)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(inData, (::nn::jitsrv::Struct32), 48)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(5, (inDataSize, tag, rxRange, roRange, inData))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(80)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pGeneratedRx, (::nn::jit::CodeRange), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pGeneratedRo, (::nn::jit::CodeRange), 24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(3, (pOut, pGeneratedRx, pGeneratedRo))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(40)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pGeneratedRx), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pGeneratedRo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(source), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(tag), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rxRange), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(roRange), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inDataSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GenerateCode)

    // nn::Result Control(nn::sf::Out<std::int32_t> pOut, std::uint64_t tag, const nn::sf::InBuffer& inData, const nn::sf::OutBuffer& outData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Control)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inData, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outData, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (inData, outData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(tag, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (tag))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(tag), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Control)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::jit::CodeRange), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::jitsrv::Struct32), 32, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::jitsrv::IJitEnvironment, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_WITH_BASE((::nn::jitsrv::IJitEnvironment), (::nn::jitsrv::IJitEnvironmentBase))

    // nn::Result GenerateCode(nn::sf::Out<std::int32_t> pOut, nn::sf::Out<nn::jit::CodeRange> pGeneratedRx, nn::sf::Out<nn::jit::CodeRange> pGeneratedRo, const nn::sf::InBuffer& source, std::uint64_t tag, const nn::jit::CodeRange& rxRange, const nn::jit::CodeRange& roRange, const nn::jitsrv::Struct32& inData, std::uint32_t inDataSize, const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GenerateCode, (::nn::sf::Out<::std::int32_t> pOut, ::nn::sf::Out<::nn::jit::CodeRange> pGeneratedRx, ::nn::sf::Out<::nn::jit::CodeRange> pGeneratedRo, const ::nn::sf::InBuffer& source, ::std::uint64_t tag, const ::nn::jit::CodeRange& rxRange, const ::nn::jit::CodeRange& roRange, const ::nn::jitsrv::Struct32& inData, ::std::uint32_t inDataSize, const ::nn::sf::OutBuffer& outBuffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GenerateCode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pGeneratedRx)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pGeneratedRo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(source)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(tag)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rxRange)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(roRange)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inDataSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GenerateCode)
    }

    // nn::Result Control(nn::sf::Out<std::int32_t> pOut, std::uint64_t tag, const nn::sf::InBuffer& inData, const nn::sf::OutBuffer& outData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Control, (::nn::sf::Out<::std::int32_t> pOut, ::std::uint64_t tag, const ::nn::sf::InBuffer& inData, const ::nn::sf::OutBuffer& outData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Control)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(tag)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Control)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::jitsrv::IJitEnvironment>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_WITH_BASE((::nn::jitsrv::IJitEnvironment), (::nn::jitsrv::IJitEnvironmentBase))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GenerateCode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(source)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GenerateCode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pGeneratedRx),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pGeneratedRo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(source),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(tag),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(rxRange),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(roRange),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(inData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(inDataSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Control)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inData)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Control)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(tag),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GenerateCode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Control)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END_WITH_BASE

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::jitsrv::IJitEnvironment))

namespace nn { namespace jitsrv { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IJitService, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IJitService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateJitEnvironment, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::jitsrv::IJitEnvironment>> pOut, ::nn::sf::NativeHandle&& processHandle, ::nn::sf::NativeHandle&& rxHandle, ::std::uint64_t rxSize, ::nn::sf::NativeHandle&& roHandle, ::std::uint64_t roSize))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IJitService)

        ::nn::Result CreateJitEnvironment(::nn::sf::Out<::nn::sf::SharedPointer<::nn::jitsrv::IJitEnvironment>> pOut, ::nn::sf::NativeHandle&& processHandle, ::nn::sf::NativeHandle&& rxHandle, ::std::uint64_t rxSize, ::nn::sf::NativeHandle&& roHandle, ::std::uint64_t roSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateJitEnvironment, (pOut, ::std::move(processHandle), ::std::move(rxHandle), rxSize, ::std::move(roHandle), roSize));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IJitService
    {
    public:
        nn::Result CreateJitEnvironment(nn::sf::Out<nn::sf::SharedPointer<nn::jitsrv::IJitEnvironment>> pOut, nn::sf::NativeHandle&& processHandle, nn::sf::NativeHandle&& rxHandle, std::uint64_t rxSize, nn::sf::NativeHandle&& roHandle, std::uint64_t roSize) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result CreateJitEnvironment(nn::sf::Out<nn::sf::SharedPointer<nn::jitsrv::IJitEnvironment>> pOut, nn::sf::NativeHandle&& processHandle, nn::sf::NativeHandle&& rxHandle, std::uint64_t rxSize, nn::sf::NativeHandle&& roHandle, std::uint64_t roSize) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::jitsrv::IJitService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateJitEnvironment, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::jitsrv::IJitEnvironment>> pOut, ::nn::sf::NativeHandle&& processHandle, ::nn::sf::NativeHandle&& rxHandle, ::std::uint64_t rxSize, ::nn::sf::NativeHandle&& roHandle, ::std::uint64_t roSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateJitEnvironment, (pOut, ::std::move(processHandle), ::std::move(rxHandle), rxSize, ::std::move(roHandle), roSize));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::jitsrv::IJitService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::jitsrv::IJitService))

    // nn::Result CreateJitEnvironment(nn::sf::Out<nn::sf::SharedPointer<nn::jitsrv::IJitEnvironment>> pOut, nn::sf::NativeHandle&& processHandle, nn::sf::NativeHandle&& rxHandle, std::uint64_t rxSize, nn::sf::NativeHandle&& roHandle, std::uint64_t roSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateJitEnvironment)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOut, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(processHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(rxHandle, 1, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(roHandle, 2, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(3, (processHandle, rxHandle, roHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(rxSize, (::std::uint64_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(roSize, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (rxSize, roSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rxHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rxSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(roHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(roSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateJitEnvironment)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::jitsrv::IJitService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::jitsrv::IJitService))

    // nn::Result CreateJitEnvironment(nn::sf::Out<nn::sf::SharedPointer<nn::jitsrv::IJitEnvironment>> pOut, nn::sf::NativeHandle&& processHandle, nn::sf::NativeHandle&& rxHandle, std::uint64_t rxSize, nn::sf::NativeHandle&& roHandle, std::uint64_t roSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateJitEnvironment, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::jitsrv::IJitEnvironment>> pOut, ::nn::sf::NativeHandle&& processHandle, ::nn::sf::NativeHandle&& rxHandle, ::std::uint64_t rxSize, ::nn::sf::NativeHandle&& roHandle, ::std::uint64_t roSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateJitEnvironment)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rxHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rxSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(roHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(roSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateJitEnvironment)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::jitsrv::IJitService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::jitsrv::IJitService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateJitEnvironment)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(processHandle)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(rxHandle)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(roHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::jitsrv::IJitEnvironment>), pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateJitEnvironment)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(processHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(rxHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(rxSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(roHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(roSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOut, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateJitEnvironment)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::jitsrv::IJitService))
